package cn.quant.andy.service;

import cn.quant.andy.TransactionSession;
import cn.quant.spring.context.ServerApplicationContext;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Administrator on 2021/7/24 0024.
 */
public abstract class AbstractService {
    @Autowired
    private ServerApplicationContext serverApplicationContext;

    private static final ThreadLocal<TransactionSession> local = new ThreadLocal();

    public TransactionSession session() {
        if (local.get() != null) {
            return local.get();
        }

        TransactionSession session = new TransactionSession(serverApplicationContext);
        local.set(session);
        return session;
    }

    public void release() {
        local.remove();
    }
}
