package cn.quant.andy;

import cn.quant.andy.csv.CSVReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Created by Administrator on 2021/7/19 0019.
 */
public class SnapshotDataLoader implements DataLoader {

    private static final Logger logger = LoggerFactory.getLogger(SnapshotDataLoader.class);

    private Map<String, SnapshotDataOptions> options;

    public SnapshotDataLoader() {
        this(new HashMap());
    }

    public SnapshotDataLoader(Map<String, SnapshotDataOptions> options) {
        this.options = options;
    }

    public void setLoaderOptions(String name, SnapshotDataOptions option) {
        options.put(name, option);
    }

    @Override
    public void load(int term) throws Exception {
        Set<String> keySet = options.keySet();
        for (String key : keySet) {
            SnapshotDataOptions options = this.options.get(key);
            long millis = System.currentTimeMillis();
            logger.info(">>> start load data. {} - {}", millis, options.getName());
            CSVReader.read(term, options.getImportFile()
                    , options.getStartLine()
                    , options.getHandler());
            logger.info("<<< end load data. {} - {}", millis, System.currentTimeMillis() - millis);
        }
    }
}
