package cn.quant.andy;

import cn.quant.andy.csv.CSVRecordHandler;
import cn.quant.andy.jpa.model.ImportMapSchema;
import cn.quant.andy.text.StringFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.util.List;

/**
 * Created by Administrator on 2021/7/19 0019.
 */
public class SummaryHandler implements CSVRecordHandler {
    private static final Logger logger = LoggerFactory.getLogger(SummaryHandler.class);

    private String name;

    private List<ImportMapSchema> schemas;

    private String prefix;

    private SummaryRepository repository;

    public SummaryHandler(String name, String prefix) {
        this.name = name;
        this.prefix = prefix;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<ImportMapSchema> getSchemas() {
        return schemas;
    }

    public void setSchemas(List<ImportMapSchema> schemas) {
        this.schemas = schemas;
    }

    public SummaryRepository getRepository() {
        return repository;
    }

    public void setRepository(SummaryRepository repository) {
        this.repository = repository;
    }

    @Override
    public boolean read(int term, long number, String[] record) {
        List<String> fields = getRepository().fields();
        Object[] objects = new Object[fields.size()];
        try {
            for (ImportMapSchema schema : schemas) {
                parse(schema, record, objects);
            }
            repository.importData(name, term, objects);
        } catch (Exception e) {
            logger.error("CSV record parse exception - " + String.join(",", record) + "; " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Object[] parse(ImportMapSchema schema, String[] record, Object[] values) throws ParseException {
        int i = Integer.parseInt(schema.getColumn()) - 1;
        String value = record[i];
        if ((prefix != null) && (prefix.length() > 0) && (record[i].startsWith(prefix))) {
            value = value.substring(prefix.length());
        }
        String index = schema.getIndex();
        if (schema.getFormat() != null) {
            StringFormatter.Group group = StringFormatter.format(schema.getType(), schema.getFormat(), value);
            String placeholder;
            while (group != null) {
                placeholder = group.getPlaceholder();
                if (index == null) {
                    if (placeholder == null || placeholder.length() == 0) {

                    } else {
                        values[Integer.parseInt(placeholder) - 1] = group.getValue();
                    }
                } else {
                    values[Integer.parseInt(index) - 1] = group.getValue();
                }
                group = group.next();
            }
        } else {
            values[Integer.parseInt(index) - 1] = value;
        }
        return values;
    }
}
