##1、 ps_pay_inf_sku
###1.1 pay_inf_sku 关联SKU信息表
```
SELECT
	oinf.TERM_NO,
	oinf.ID,
	oinf.ROOT_ORDER_NO,
	oinf.ORDER_NO,
	oinf.ORDER_TYPE,
	oinf.order_status,
	oinf.order_time,
	oinf.pay_time,
	oinf.delivery_at,
	oinf.PAY_TYPE,
	oinf.order_complete_time,
	osku.SKU_NO,
	osku.shop_name,
	osku.sku_name,
	osku.price,
	osku.cost_price,
	osku.amount,
	osku.pay_amount,
	osku.count
FROM
	t_order_info oinf
LEFT JOIN order_sku osku ON osku.TERM_NO = oinf.TERM_NO
AND oinf.ROOT_ORDER_NO = osku.order_no
WHERE
	oinf.TERM_NO = 202108
AND oinf.ORDER_STATUS <> '51'
GROUP BY
	oinf.ROOT_ORDER_NO,
	osku.SKU_NO;
```

###1.2  ps_pay_inf_sku 拉取商品信息表
```
SELECT
	isku.ID AS 'ORDER_INFO_ID',
	psts.ORDER_GOODS_ID AS 'ORDER_GOODS_ID',
	psts.FLOW_NO AS 'FLOW_NO',
	skui.ID AS 'ID',
	psts.TERM_NO AS 'TERM_NO',
	psts.ORDER_NO AS 'ROOT_ORDER_NO',
	isku.ORDER_NO AS 'SUB_ORDER_NO',
	psts.SKU_NO AS 'SKU_NO',
	gcat1.CATEGROY_NAME AS 'CATEGROY_NAME1',
	gcat2.CATEGROY_NAME AS 'CATEGROY_NAME2',
	gcat3.CATEGROY_NAME AS 'CATEGROY_NAME3',
	skui.BRAND_NAME AS 'BRAND_NAME',
	isku.SHOP_NAME AS 'SHOP_NAME',
	isku.SKU_NAME AS 'SKU_NAME',
	isku.ORDER_TYPE AS 'ORDER_TYPE',
	isku.order_status AS 'ORDER_STATUS',
	isku.PAY_TYPE AS 'PAY_TYPE',
	CASE psts.TXN_CODE
WHEN 'R004' THEN
	psts.POST_AMT
ELSE
	0.0
END AS 'VCC_AMT',
 CASE psts.TXN_CODE
WHEN 'R002' THEN
	psts.POST_AMT
ELSE
	0.0
END AS 'WX_AMT',
 CASE psts.TXN_CODE
WHEN 'R003' THEN
	psts.POST_AMT
ELSE
	0.0
END AS 'ZFB_AMT',
 isku.AMOUNT AS 'AMOUNT',
 isku.COUNT AS 'COUNT',
 isku.PAY_AMOUNT AS 'PAY_AMOUNT',
 ogd_inf.AMT_DEDUCT_PAY_COUPON AS 'AMT_DEDUCT_PAY_COUPON',
 ogd_inf.AMT_CASH_COUPON_DEDUCT AS 'AMT_CASH_COUPON_DEDUCT',
 ogd_inf.AMT_COUPON_DEDUCT AS 'AMT_COUPON_DEDUCT',
 ogd_inf.AMT_ACTIVITY_DEDUCT AS 'AMT_ACTIVITY_DEDUCT',
 ogd_inf.AMT_NEED_PAY AS 'AMT_NEED_PAY',
 psts.POST_AMT AS 'POST_AMT',
 isku.PRICE AS 'PRICE',
 isku.COST_PRICE AS 'COST_PRICE',
 ogd_inf.AMT_FREIGHT AS 'AMT_FREIGHT',
 ogd_inf.AMT_FREIGHT_DEDUCT AS 'AMT_FREIGHT_DEDUCT',
 isku.ORDER_TIME AS 'ORDER_TIME',
 isku.PAY_TIME AS 'PAY_TIME',
 isku.DELIVERY_AT AS 'DELIVERY_AT',
 isku.ORDER_COMPLETE_TIME AS 'ORDER_COMPLETE_TIME'
FROM
	ps_txn_summary psts
LEFT JOIN pay_inf_sku isku ON psts.ORDER_NO = isku.ROOT_ORDER_NO
AND psts.SKU_NO = isku.SKU_NO
AND psts.TERM_NO = isku.term_no
LEFT JOIN order_goods_info ogd_inf ON ogd_inf.ID = psts.ORDER_GOODS_ID
LEFT JOIN sku_info skui ON psts.SKU_NO = skui.SKU_NO
LEFT JOIN t_goods_rear_category gcat1 ON skui.C_ID1 = gcat1.CATEGROY_ID
LEFT JOIN t_goods_rear_category gcat2 ON skui.C_ID1 = gcat2.CATEGROY_ID
LEFT JOIN t_goods_rear_category gcat3 ON skui.C_ID2 = gcat3.CATEGROY_ID
WHERE
	psts.TERM_NO = 202108
AND ROOT_ORDER_NO IN (
'1432734833913839616',
'1432671460492763136'
)
```

#2、ps_pay_sku_bill 合并SKU粒度表
```
--合计应付金额 = 合计商品金额 + 合计运费金额
--合计支付金额 = 合计商品金额 + 合计运费金额 - 支付减免券金额 - 现金减免券金额 - 优惠券券减免金额 - 活动减免金额
--核应付实付 = (合计商品金额 + 运费金额 - 运费抵扣金额 - 实付金额 - 支付减免券金额 - 现金减免券金额 - 优惠券减免券金额 - 活动减免金额 = 0.0)
--核商品金额 = (合计商品金额 - 商品售价 * 合计商品数量 == 0.0)
--核实付金额 = (VCC支付金额 + 微信支付金额+ 支付宝支付金额 - 实付金额 == 0.0)
SELECT
	pspis.TERM_NO AS 'TERM_NO',
	-- 	pspis.ORDER_INFO_ID,
	CONCAT('#', pspis.ROOT_ORDER_NO) AS 'ROOT_ORDER_NO',
	CONCAT('#', pspis.SUB_ORDER_NO) AS 'SUB_ORDER_NO',
	CONCAT('#', pspis.SKU_NO) AS 'SKU_NO',
	pspis.CATEGROY_NAME1 AS 'CATEGROY_NAME1',
	pspis.CATEGROY_NAME2 AS 'CATEGROY_NAME2',
	pspis.CATEGROY_NAME3 AS 'CATEGROY_NAME3',
	pspis.BRAND_NAME AS 'BRAND_NAME',
	pspis.SHOP_NAME AS 'SHOP_NAME',
	pspis.SKU_NAME AS 'SKU_NAME',
	CASE pspis.ORDER_TYPE
WHEN 1 THEN
	'自营'
WHEN 2 THEN
	'京东开普勒'
WHEN 3 THEN
	'京东联盟'
WHEN 4 THEN
	'众联'
WHEN 5 THEN
	'众联企业购'
WHEN 6 THEN
	'京东企业购'
END AS 'ORDER_TYPE',
 CASE pspis.order_status
WHEN '' THEN
	'空值'
WHEN '11' THEN
	'待付款'
WHEN '12' THEN
	'待发货'
WHEN '13' THEN
	'待收货'
WHEN '14' THEN
	'发货中'
WHEN '21' THEN
	'订单完成'
WHEN '31' THEN
	'订单已付款主动取消'
WHEN '32' THEN
	'订单已付款自动取消'
WHEN '33' THEN
	'订单拒收取消'
WHEN '41' THEN
	'已付款主动取消退款完成订单关闭'
WHEN '42' THEN
	'已付款自动取消退款完成订单关闭'
WHEN '43' THEN
	'未支付用户主动取消订单关闭'
WHEN '44' THEN
	'未支付超时取消订单关闭'
WHEN '45' THEN
	'订单拒收退款订单取消'
WHEN '46' THEN
	'订单已付款充值失败已退款订单关闭'
WHEN '51' THEN
	'订单拆单关闭'
ELSE
	'未知'
END AS 'ORDER_STATUS',
 CASE pspis.PAY_TYPE
WHEN '' THEN
	'空类型支付'
WHEN '1' THEN
	'微信支付'
WHEN '2' THEN
	'额度支付'
WHEN '3' THEN
	'支付宝支付'
WHEN '4' THEN
	'微信+信用支付'
WHEN '5' THEN
	'支付宝加信用支付'
WHEN '6' THEN
	'未知类型支付'
END AS 'PAY_TYPE',
 SUM(pspis.VCC_AMT) AS 'VCC_AMT',
 SUM(pspis.WX_AMT) AS 'WX_AMT',
 SUM(pspis.ZFB_AMT) AS 'ZFB_AMT',
 MAX(pspis.amount) AS 'AMOUNT',
 MAX(pspis.COUNT) AS 'COUNT',
 --  SUM(1) AS 'TOTAL_COUNT',
--  SUM(pspis.amt_freight) AS 'TOTAL_AMT_FREIGHT',
(
	SUM(pspis.amt_freight) / SUM(1) * MAX(pspis.count) - SUM(pspis.AMT_FREIGHT_DEDUCT) / SUM(1) * MAX(pspis.count)
) AS 'POST_AMT_FREIGHT',
 MAX(pspis.pay_amount) AS 'PAY_AMOUNT',
 SUM(pspis.amt_deduct_pay_coupon) / SUM(1) * MAX(pspis.count) AS 'AMT_DEDUCT_PAY_COUPON',
 SUM(pspis.amt_cash_coupon_deduct) / SUM(1) * MAX(pspis.count) AS 'AMT_CASH_COUPON_DEDUCT',
 SUM(pspis.amt_coupon_deduct) / SUM(1) * MAX(pspis.count) AS 'AMT_COUPON_DEDUCT',
 SUM(pspis.amt_activity_deduct) / SUM(1) * MAX(pspis.count) AS 'AMT_ACTIVITY_DEDUCT',
 SUM(pspis.amt_need_pay) / SUM(1) * MAX(pspis.count) AS 'AMT_NEED_PAY',
 SUM(pspis.POST_AMT) AS 'POST_AMT',

 CASE
WHEN CAST(
(MAX(pspis.amount) 
+ (SUM(pspis.amt_freight) / SUM(1) * MAX(pspis.count))
- SUM(pspis.POST_AMT) 
- (SUM(pspis.AMT_FREIGHT_DEDUCT) / SUM(1) * MAX(pspis.count)) 
- (SUM(pspis.amt_deduct_pay_coupon) / SUM(1) * MAX(pspis.count))
- (SUM(pspis.amt_cash_coupon_deduct) / SUM(1) * MAX(pspis.count))
- (SUM(pspis.amt_coupon_deduct) / SUM(1) * MAX(pspis.count))
- (SUM(pspis.amt_activity_deduct)/ SUM(1) * MAX(pspis.count))) AS DECIMAL(10,3))=0.000 THEN
	'Y'
ELSE
	'N'
END AS 'CHECKED_PAY',
 CASE
WHEN MAX(pspis.amount) - (pspis.PRICE * pspis.count) = 0.0 THEN
	'Y'
ELSE
	'N'
END AS 'CHECKED_AMT',
 CASE
WHEN SUM(pspis.VCC_AMT + pspis.WX_AMT + pspis.ZFB_AMT) - SUM(pspis.POST_AMT) = 0.000 THEN
	'Y'
ELSE
	'N'
END AS 'CHECKED_PAY_AMT',
 pspis.PRICE AS 'PRICE',
 pspis.COST_PRICE AS 'COST_PRICE',
 SUM(pspis.amt_freight) / SUM(1) * MAX(pspis.count) AS 'AMT_FREIGHT',
 SUM(pspis.AMT_FREIGHT_DEDUCT) / SUM(1) * MAX(pspis.count) AS 'AMT_FREIGHT_DEDUCT',
 pspis.ORDER_TIME AS 'ORDER_TIME',
 pspis.PAY_TIME AS 'PAY_TIME',
 pspis.DELIVERY_AT AS 'DELIVERY_AT',
 pspis.ORDER_COMPLETE_TIME AS 'ORDER_COMPLETE_TIME',
 GROUP_CONCAT(pspis.FLOW_NO) AS 'FLOW_NO'
FROM
	`ps_pay_inf_sku` pspis
WHERE
	pspis.TERM_NO = 202108 
-- and pspis.ROOT_ORDER_NO IN (
-- '1432734833913839616'
-- )
GROUP BY
	pspis.ROOT_ORDER_NO,
	pspis.SKU_NO;
```


#3、pay_sku_bill 出SKU粒度的核对明细
```
SELECT
	CONCAT('#', pspsb.`ROOT_ORDER_NO`) AS '根订单号',
	CONCAT('#', pspsb.`SUB_ORDER_NO`) AS '子订单号',
	CONCAT('#', pspsb.`SKU_NO`) AS 'SKU号',
	pspsb.`CATEGROY_NAME1` AS '一级品类',
	pspsb.`CATEGROY_NAME2` AS '二级品类',
	pspsb.`CATEGROY_NAME3` AS '三级品类',
	pspsb.`BRAND_NAME` AS '品牌',
	pspsb.`SHOP_NAME` AS '店铺',
	pspsb.`SKU_NAME` AS '商品名称',
	pspsb.`ORDER_TYPE` AS '商品来源',
	pspsb.`ORDER_STATUS` AS '订单状态',
	pspsb.`PAY_TYPE` AS '支付方式',
	pspsb.`VCC_AMT` AS 'VCC支付金额/元',
	pspsb.`WX_AMT` AS '微信支付金额/元',
	pspsb.`ZFB_AMT` AS '支付宝支付金额/元',
	pspsb.`AMOUNT` AS '合计商品金额/元',
	pspsb.`COUNT` AS '合计商品数量/件',
	pspsb.`POST_AMT_FREIGHT` AS '合计运费金额/元',
	pspsb.`PAY_AMOUNT` AS '合计应付总额/元',
	pspsb.`AMT_DEDUCT_PAY_COUPON` AS '支付减免券金额/元',
	pspsb.`AMT_CASH_COUPON_DEDUCT` AS '现金减免券金额/元',
	pspsb.`AMT_COUPON_DEDUCT` AS '优惠券减免券金额/元',
	pspsb.`AMT_ACTIVITY_DEDUCT` AS '活动减免金额/元',
	pspsb.`AMT_NEED_PAY` AS '合计支付金额/元',
	pspsb.`POST_AMT` AS '实付金额/元',
	pspsb.`CHECKED_PAY` AS '核应付实付',
	pspsb.`CHECKED_AMT` AS '核商品金额',
	pspsb.`CHECKED_PAY_AMT` AS '核实付金额',
	pspsb.`PRICE` AS '商品零售价/元',
	pspsb.`COST_PRICE` AS '商品成本/元',
	pspsb.`AMT_FREIGHT` AS '运费金额/元',
	pspsb.`AMT_FREIGHT_DEDUCT` AS '运费抵扣金额/元',
	pspsb.`ORDER_TIME` AS '下单时间',
	pspsb.`PAY_TIME` AS '支付时间',
	pspsb.`DELIVERY_AT` AS '发货时间',
	pspsb.`ORDER_COMPLETE_TIME` AS '订单完成时间',
	pspsb.`FLOW_NO` AS '流水号'
FROM
	ps_pay_sku_bill pspsb;
```