package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.PayRequestData;
import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.config.MerchantAcquirerBuilder;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.model.AssertUtils;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.model.MerchantAcquirerProfile;
import cn.quant.baa.pay.service.TransactionService;
import cn.quant.spring.rest.AbstractController;
import cn.quant.spring.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import static cn.quant.baa.pay.dict.MessageEnum.*;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@RestController
@RequestMapping("/transaction")
public class TransactionController extends AbstractController {

    @Autowired
    private TransactionService transactionService;

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/pay")
    public void pay(@RequestBody BusinessRequest<PayRequestData> request) {
        TransactionSession session = TransactionSession.session();
        String requestId = session.getRequestId();

        PayRequestData data = request.getData();


        transactionService.pay(data, session);


        System.currentTimeMillis();
    }
}
