package cn.quant.baa.pay.service;

import cn.quant.baa.pay.PayRequestData;
import cn.quant.baa.pay.config.MerchantAcquirerBuilder;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.model.AssertUtils;
import cn.quant.baa.pay.model.MerchantAcquirerProfile;
import cn.quant.spring.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static cn.quant.baa.pay.dict.MessageEnum.*;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@Service
public class TransactionService extends BusinessService {

    private static final Logger logger = LoggerFactory.getLogger(TransactionService.class);


    @Autowired
    private MerchantAcquirerBuilder merchantAcquirerBuilder;

    public void pay(PayRequestData data, TransactionSession session) {

        if (data == null) {
            AssertUtils.throwMessage(EMPTY_REQ_DATA);
        }
        String chanId = data.getChanId();
        if (StringUtils.isEmpty(chanId)) {
            AssertUtils.throwMessage(CHAN_ID_ILLEGAL);
        }
        String mchId = data.getMchId();
        if (StringUtils.isEmpty(mchId)) {
            AssertUtils.throwMessage(MCH_ID_ILLEGAL);
        }

        MerchantAcquirerProfile profile = merchantAcquirerBuilder.get(Long.valueOf(chanId));
        if (profile == null) {
            AssertUtils.throwMessage(ACQUIRER_NOSUCH);
        }
        if (!mchId.equals(profile.getPayAppId())) {
            AssertUtils.throwMessage(ACQUIRER_NOMATCH);
        }

        prepare(profile.getInstitutionId(), profile.getProductId(), StringUtils.trimAllWhitespace(data.getBuyerId()), session);

        System.currentTimeMillis();
    }
}
