package cn.quant.baa.pay.service;

import cn.quant.baa.pay.component.Sequencer;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.dict.AcctTypeId;
import cn.quant.baa.pay.dict.CurrencyCode;
import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.baa.pay.jpa.entity.AccountEntity;
import cn.quant.baa.pay.jpa.entity.AccountIds;
import cn.quant.baa.pay.model.AssertUtils;
import cn.quant.spring.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.time.LocalDate;

import static cn.quant.baa.pay.Constant.MINI_LOCAL_DATE;
import static cn.quant.baa.pay.dict.MessageEnum.*;

/**
 * Created by Administrator on 2021/8/25 0025.
 */
public abstract class BusinessService {

    private static final Logger logger = LoggerFactory.getLogger(BusinessService.class);

    @Autowired
    private Sequencer sequencer;

    public void prepare(String institutionId, String productId, String buyerId, TransactionSession session) {

        if (StringUtils.isEmpty(institutionId)) {
            AssertUtils.throwMessage(INSTITUTION_ID_ILLEGAL);
        }

        if (StringUtils.isEmpty(productId)) {
            AssertUtils.throwMessage(PRODUCT_ID_ILLEGAL);
        }

        if (StringUtils.isEmpty(buyerId)) {
            AssertUtils.throwMessage(BUYER_ID_ILLEGAL);
        }

        AccountIds ids = new AccountIds();
        ids.setInstitutionId(institutionId);
        ids.setAccountRefNo(buyerId);
        AccountEntity account = session.findOne(AccountEntity.class, ids, session);
        if (account == null) {
            Long id = sequencer.nextId(buyerId.hashCode());
            LocalDate now = LocalDate.now();
            account = new AccountEntity();
            account.setIds(ids);
            account.setAccountId(id);
            account.setAcctTypeId(AcctTypeId.EMPS);
            account.setAutoPaymentFlag(false);
            account.setAutoPaymentWarnDate(MINI_LOCAL_DATE);
            account.setAutoStatus(StatusCode.NORM);
            account.setAutoStatusDate(now);
            account.setCorpotateAcctFlag(false);
            account.setCreditTxnCount(0);
            account.setCurrencyCode(CurrencyCode.CNY);
            account.setCurrentCycleNo(1);
            account.setDebitTxtCount(0);
            account.setExternalAcctNo(buyerId);
            account.setManualStatus(null);
            account.setManualStatusDate(null);
            account.setNextTxnNo(1);
            account.setOpenDate(now);
            account.setProductId(productId);
            account.setProtocolRule(null);
            account.setTotalCredit(BigDecimal.ZERO);
            account.setTotalDebit(BigDecimal.ZERO);
            account.setTxnNo(0);
            account.setPartitionKey(sequencer.getPartitionKey(id));
            session.pushEntity(account);
        }
    }
}
