package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.PayChanType;
import cn.quant.spring.data.jpa.entity.OptimisticEntity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Entity
@Table(name = "pay_account")
public class PayAccountEntity extends OptimisticEntity implements Serializable {

    private static final long serialVersionUID = 272268892694382599L;

    @EmbeddedId
    private PayAccountIds ids;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "PAY_CHAN_TYPE", nullable = false, length = 4)
    private PayChanType payChanType;

    @Column(name = "DOMAIN", nullable = false, length = 255)
    private String domain;

    @Column(name = "NAME", nullable = false, length = 255)
    private String name;

    @Column(name = "ENCRYPT_KEY", nullable = false, length = 64)
    private String encryptKey;

    @Column(name = "ENCRYPT_TYPE", nullable = false, length = 32)
    private String encryptType;

    @Column(name = "PRIVATE_KEY", nullable = false, length = 255)
    private String privateKey;

    @Column(name = "PAY_PUBLIC_KEY", nullable = false, length = 255)
    private String payPublicKey;

    public PayAccountIds getIds() {
        return ids;
    }

    public void setIds(PayAccountIds ids) {
        this.ids = ids;
    }

    public PayChanType getPayChanType() {
        return payChanType;
    }

    public void setPayChanType(PayChanType payChanType) {
        this.payChanType = payChanType;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEncryptKey() {
        return encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public String getEncryptType() {
        return encryptType;
    }

    public void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPayPublicKey() {
        return payPublicKey;
    }

    public void setPayPublicKey(String payPublicKey) {
        this.payPublicKey = payPublicKey;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PayAccountEntity)) return false;
        PayAccountEntity that = (PayAccountEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayAccountEntity{");
        sb.append("ids=").append(ids);
        sb.append(", payChanType=").append(payChanType);
        sb.append(", domain='").append(domain).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", encryptKey='").append(encryptKey).append('\'');
        sb.append(", encryptType='").append(encryptType).append('\'');
        sb.append(", privateKey='").append(privateKey).append('\'');
        sb.append(", payPublicKey='").append(payPublicKey).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }

}
