package cn.quant.baa.pay.aspect;

import cn.quant.spring.annotation.ThreadSession;
import cn.quant.spring.context.ServerApplicationContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Aspect
@Component
public class ThreadSessionAspect {

    private static final Logger logger = LoggerFactory.getLogger(ThreadSessionAspect.class);

    @Pointcut("@annotation(cn.quant.spring.annotation.ThreadSession)")
    public void pointCut() {
    }

    @Around("pointCut()")
    public Object Around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        ThreadSession annotation = method.getAnnotation(ThreadSession.class);
        logger.info("---->>>> Thread session aspect {}.", annotation.value());
        Object object = joinPoint.proceed();
        return object;
    }
}
