package cn.quant.baa.pay;

import java.io.Serializable;
import java.util.Arrays;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
public class PayRequestData implements Serializable{

    private static final long serialVersionUID = -8274612481658761761L;

    /**
     * 订单标题
     */
    private String subject;

    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 支付通道ID
     */
    private String chanId;

    /**
     * 商户订单号
     */
    private String outTradeNo;

    /**
     * 原订单金额
     */
    private String originalAmount;

    /**
     *实际订单金额
     */
    private String amount;

    /**
     * 优惠金额
     */
    private String discounts;

    /**
     * 通知地址
     */
    private String notifyUrl;

    /**
     *买家ID
     */
    private String buyerId;

    /**
     * 附加信息
     */
    private String attach;

    /**
     * 收货人名称
     */
    private String goodsSigner;

    /**
     * 联系电话
     */
    private String phoneNo;

    /**
     * 地址
     */
    private String address;

    /**
     * 商品列表
     */
    private GoodsDetail[] goodsDetail;

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getChanId() {
        return chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOriginalAmount() {
        return originalAmount;
    }

    public void setOriginalAmount(String originalAmount) {
        this.originalAmount = originalAmount;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getDiscounts() {
        return discounts;
    }

    public void setDiscounts(String discounts) {
        this.discounts = discounts;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getGoodsSigner() {
        return goodsSigner;
    }

    public void setGoodsSigner(String goodsSigner) {
        this.goodsSigner = goodsSigner;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public GoodsDetail[] getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(GoodsDetail[] goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayRequestData{");
        sb.append("subject='").append(subject).append('\'');
        sb.append(", mchId='").append(mchId).append('\'');
        sb.append(", chanId='").append(chanId).append('\'');
        sb.append(", outTradeNo='").append(outTradeNo).append('\'');
        sb.append(", originalAmount='").append(originalAmount).append('\'');
        sb.append(", amount='").append(amount).append('\'');
        sb.append(", discounts='").append(discounts).append('\'');
        sb.append(", notifyUrl='").append(notifyUrl).append('\'');
        sb.append(", buyerId='").append(buyerId).append('\'');
        sb.append(", attach='").append(attach).append('\'');
        sb.append(", goodsSigner='").append(goodsSigner).append('\'');
        sb.append(", phoneNo='").append(phoneNo).append('\'');
        sb.append(", address='").append(address).append('\'');
        sb.append(", goodsDetail=").append(goodsDetail == null ? "null" : Arrays.asList(goodsDetail).toString());
        sb.append('}');
        return sb.toString();
    }
}
