package cn.quant.baa.pay.model;

import cn.quant.baa.pay.MerchantAcquirer;
import cn.quant.baa.pay.MerchantAcquirerBook;
import cn.quant.baa.pay.config.DictionaryViewer;
import cn.quant.baa.pay.dict.DictType;
import cn.quant.spring.UnsupportedException;
import cn.quant.spring.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Service
public class ModelBuilder {

    @Autowired
    private DictionaryViewer dictionaryViewer;

    public MerchantAcquirer toModel(MerchantAcquirerProfile profile) {
        MerchantAcquirer response = new MerchantAcquirer();
        response.setAccessCode(profile.getAccessCode().name());
        response.setAccessType(profile.getAccessType().name());
        response.setChanCode(profile.getPayChanCode());
        response.setChanId(profile.getMchChanId());
        response.setChanType(profile.getPayChanType().name());
        response.setName(profile.getName());
        response.setVersion(profile.getVersion());
        response.setDescText(profile.getDescText());
        return response;
    }

    public Collection<MerchantAcquirer> toModel(Collection<MerchantAcquirerProfile> profiles) {
        LinkedList<MerchantAcquirer> list = new LinkedList<>();
        for (MerchantAcquirerProfile profile : profiles) {
            list.add(toModel(profile));
        }
        return list;
    }

    public Map<String, MerchantAcquirerBook> toModel(Map<String, Collection<MerchantAcquirerProfile>> profiles) {
        Map<String, MerchantAcquirerBook> models = new HashMap<>();
        for (String code : profiles.keySet()) {
            DictionaryItem item = dictionaryViewer.get(DictType.PAY, code);
            if (item == null) {
                throw new UnsupportedException(StringUtils.format("Dictionary item is null({}, {}).", DictType.PAY, code));
            }
            Collection<MerchantAcquirerProfile> collection = profiles.get(code);
            MerchantAcquirerBook book = new MerchantAcquirerBook();
            book.setCode(code);
            book.setName(item.getName());
            book.setImageUrl(item.getImageUrl());
            for (MerchantAcquirerProfile profile : collection) {
                book.add(toModel(profile));
            }
            models.put(book.getCode(), book);
        }
        return models;
    }
}
