package cn.quant.baa.pay.model;

import cn.quant.baa.pay.BusinessException;
import cn.quant.baa.pay.dict.MessageEnum;
import cn.quant.spring.NullException;
import cn.quant.spring.context.ContextLoader;
import cn.quant.spring.context.ServerApplicationContext;
import cn.quant.spring.util.StringUtils;

import java.util.Locale;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
public class AssertUtils {

    public static String getMessage(MessageEnum code, Object... args){
        ServerApplicationContext context = ContextLoader.getCurrentApplicationContext();
        return context.getMessage(code.name(), args, Locale.SIMPLIFIED_CHINESE);
    }

    public static BusinessException exception(MessageEnum code, Object... args) {
        return new BusinessException(code, getMessage(code, args));
    }

    public static void throwMessage(MessageEnum code, Object... args) throws BusinessException {
        throw exception(code, args);
    }

    public static void throwMessage(MessageEnum code) throws BusinessException {
        ServerApplicationContext context = ContextLoader.getCurrentApplicationContext();
        throw new BusinessException(code, context.getMessage(code.name(), Locale.SIMPLIFIED_CHINESE));
    }

    public static void notEmpty(String requestId, Object val, Class cls) {
        if (val == null) {
            throw new NullException(StringUtils.format("{} data is null - {}", cls.getSimpleName(), requestId));
        }
    }

    public static void notEmpty(String requestId, Number val, String msg) {
        if(StringUtils.isEmpty(val)){
            throw new NullException(msg);
        }
    }

    public static void notEmpty(String requestId, String val, String msg) {
        if(StringUtils.isEmpty(val)){
            throw new NullException(msg);
        }
    }
}
