package cn.quant.baa.pay.jpa.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/26 0026.
 */
@Entity
@Table(name = "pay_history")
public class PayHistoryEntity extends AuditedDescriptionEntity implements Serializable{

    private static final long serialVersionUID = 6297586921507136281L;
    @EmbeddedId
    private PayHistoryIds ids;

    @Column(name = "TRANSACTION_ID", nullable = false, updatable = false)
    private Long transactionId;

    @Column(name = "ACCOUNT_ID", nullable = false, updatable = false)
    private Long accountId;

    @Column(name = "PAY_APP_ID", nullable = false, updatable = false, length = 32)
    private String payAppId;

    @Column(name = "PAY_CHAN_CODE", nullable = false, updatable = false, length = 4)
    private String payChanCode;

    @Column(name = "PAY_ACCT_ID", nullable = false, updatable = false, length = 4)
    private String payAcctId;

    @Column(name = "STATUS_CODE", nullable = false, length = 4)
    private String statusCode;

    @Column(name = "TXN_UUID", nullable = false, updatable = false, length = 64)
    private String txnUuid;

    @Column(name = "CURRENCY_CODE", nullable = false, updatable = false, length = 3)
    private String currencyCode;

    @Column(name = "PAY_METHOD", nullable = false, updatable = false, length = 4)
    private String payMethod;

    @Column(name = "TXN_TYPE_CODE", nullable = false, updatable = false, length = 4)
    private String txnTypeCode;

    @Column(name = "TXN_CODE", nullable = false, updatable = false, length = 4)
    private String txnCode;

    @Column(name = "STATISTICS_CODE", nullable = false, updatable = false, length = 4)
    private String statisticsCode;

    @Column(name = "CREDIT_DEBIT_FLAG", nullable = false, updatable = false, length = 1)
    private String creditDebitFlag;

    @Column(name = "CUSTOMER_GEN_FLAG", nullable = false, updatable = false, length = 1)
    private Boolean customerGenFlag;

    @Column(name = "ORIGINAL_TXN_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal originalTxnAmount;

    @Column(name = "TXN_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal txnAmount;

    @Column(name = "POSTING_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal postingAmount;

    @Column(name = "DISC_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal discAmount;

    @Column(name = "GEN_FEE_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal genFeeAmount;

    @Column(name = "STATEMENTE_FLAG", nullable = false, updatable = false, length = 1)
    private Boolean statementeFlag;

    @Column(name = "TXN_DATE", nullable = false, updatable = false)
    private LocalDate txnDate;

    @Column(name = "TXN_TIME", nullable = false, updatable = false)
    private LocalTime txnTime;

    @Column(name = "REQUEST_ID", nullable = false, updatable = false, length = 64)
    private String requestId;

    @Column(name = "REQUEST_TIME", nullable = false, updatable = false)
    private Date requestTime;

    @Column(name = "MERCHANT_NAME", nullable = true, length = 255)
    private String merchantName;

    @Column(name = "MOBILE_PHONE", nullable = true, length = 13)
    private String mobilePhone;

    @Column(name = "NOTIFY_URL", nullable = true, length = 1000)
    private String notifyUrl;

    @Column(name = "ATTACH_TEXT", nullable = true, length = 512)
    private String attachText;

    public PayHistoryIds getIds() {
        return ids;
    }

    public void setIds(PayHistoryIds ids) {
        this.ids = ids;
    }

    public Long getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getPayAppId() {
        return payAppId;
    }

    public void setPayAppId(String payAppId) {
        this.payAppId = payAppId;
    }

    public String getPayChanCode() {
        return payChanCode;
    }

    public void setPayChanCode(String payChanCode) {
        this.payChanCode = payChanCode;
    }

    public String getPayAcctId() {
        return payAcctId;
    }

    public void setPayAcctId(String payAcctId) {
        this.payAcctId = payAcctId;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getTxnUuid() {
        return txnUuid;
    }

    public void setTxnUuid(String txnUuid) {
        this.txnUuid = txnUuid;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public String getTxnTypeCode() {
        return txnTypeCode;
    }

    public void setTxnTypeCode(String txnTypeCode) {
        this.txnTypeCode = txnTypeCode;
    }

    public String getTxnCode() {
        return txnCode;
    }

    public void setTxnCode(String txnCode) {
        this.txnCode = txnCode;
    }

    public String getStatisticsCode() {
        return statisticsCode;
    }

    public void setStatisticsCode(String statisticsCode) {
        this.statisticsCode = statisticsCode;
    }

    public String getCreditDebitFlag() {
        return creditDebitFlag;
    }

    public void setCreditDebitFlag(String creditDebitFlag) {
        this.creditDebitFlag = creditDebitFlag;
    }

    public Boolean getCustomerGenFlag() {
        return customerGenFlag;
    }

    public void setCustomerGenFlag(Boolean customerGenFlag) {
        this.customerGenFlag = customerGenFlag;
    }

    public BigDecimal getOriginalTxnAmount() {
        return originalTxnAmount;
    }

    public void setOriginalTxnAmount(BigDecimal originalTxnAmount) {
        this.originalTxnAmount = originalTxnAmount;
    }

    public BigDecimal getTxnAmount() {
        return txnAmount;
    }

    public void setTxnAmount(BigDecimal txnAmount) {
        this.txnAmount = txnAmount;
    }

    public BigDecimal getPostingAmount() {
        return postingAmount;
    }

    public void setPostingAmount(BigDecimal postingAmount) {
        this.postingAmount = postingAmount;
    }

    public BigDecimal getDiscAmount() {
        return discAmount;
    }

    public void setDiscAmount(BigDecimal discAmount) {
        this.discAmount = discAmount;
    }

    public BigDecimal getGenFeeAmount() {
        return genFeeAmount;
    }

    public void setGenFeeAmount(BigDecimal genFeeAmount) {
        this.genFeeAmount = genFeeAmount;
    }

    public Boolean getStatementeFlag() {
        return statementeFlag;
    }

    public void setStatementeFlag(Boolean statementeFlag) {
        this.statementeFlag = statementeFlag;
    }

    public LocalDate getTxnDate() {
        return txnDate;
    }

    public void setTxnDate(LocalDate txnDate) {
        this.txnDate = txnDate;
    }

    public LocalTime getTxnTime() {
        return txnTime;
    }

    public void setTxnTime(LocalTime txnTime) {
        this.txnTime = txnTime;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Date getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getAttachText() {
        return attachText;
    }

    public void setAttachText(String attachText) {
        this.attachText = attachText;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayHistoryEntity that = (PayHistoryEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayHistoryEntity{");
        sb.append("ids=").append(ids);
        sb.append(", transactionId=").append(transactionId);
        sb.append(", accountId=").append(accountId);
        sb.append(", payAppId='").append(payAppId).append('\'');
        sb.append(", payChanCode='").append(payChanCode).append('\'');
        sb.append(", payAcctId='").append(payAcctId).append('\'');
        sb.append(", statusCode='").append(statusCode).append('\'');
        sb.append(", txnUuid='").append(txnUuid).append('\'');
        sb.append(", currencyCode='").append(currencyCode).append('\'');
        sb.append(", payMethod='").append(payMethod).append('\'');
        sb.append(", txnTypeCode='").append(txnTypeCode).append('\'');
        sb.append(", txnCode='").append(txnCode).append('\'');
        sb.append(", statisticsCode='").append(statisticsCode).append('\'');
        sb.append(", creditDebitFlag='").append(creditDebitFlag).append('\'');
        sb.append(", customerGenFlag=").append(customerGenFlag);
        sb.append(", originalTxnAmount=").append(originalTxnAmount);
        sb.append(", txnAmount=").append(txnAmount);
        sb.append(", postingAmount=").append(postingAmount);
        sb.append(", discAmount=").append(discAmount);
        sb.append(", genFeeAmount=").append(genFeeAmount);
        sb.append(", statementeFlag=").append(statementeFlag);
        sb.append(", txnDate=").append(txnDate);
        sb.append(", txnTime=").append(txnTime);
        sb.append(", requestId='").append(requestId).append('\'');
        sb.append(", requestTime=").append(requestTime);
        sb.append(", merchantName='").append(merchantName).append('\'');
        sb.append(", mobilePhone='").append(mobilePhone).append('\'');
        sb.append(", notifyUrl='").append(notifyUrl).append('\'');
        sb.append(", attachText='").append(attachText).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
