package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.AccessType;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Entity
@Table(name = "pay_feature")
public class PayFeatureEntity extends AuditedDescriptionEntity implements Serializable {

    private static final long serialVersionUID = -3977191384143230391L;

    @EmbeddedId
    private PayFeatureIds ids;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "ACCESS_TYPE", nullable = false, length = 3)
    private AccessType accessType;

    @Column(name = "VERSION", nullable = false, length = 4)
    private String version;

    @Column(name = "ACCESS_PATH", nullable = true, length = 255)
    private String accessPath;

    public PayFeatureIds getIds() {
        return ids;
    }

    public void setIds(PayFeatureIds ids) {
        this.ids = ids;
    }

    public AccessType getAccessType() {
        return accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAccessPath() {
        return accessPath;
    }

    public void setAccessPath(String accessPath) {
        this.accessPath = accessPath;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayFeatureEntity that = (PayFeatureEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayFeatureEntity{");
        sb.append("ids=").append(ids);
        sb.append(", accessType='").append(accessType).append('\'');
        sb.append(", version='").append(version).append('\'');
        sb.append(", accessPath='").append(accessPath).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
