package cn.quant.baa.pay.config;

import cn.quant.baa.pay.jpa.entity.*;
import cn.quant.baa.pay.jpa.repository.*;
import cn.quant.baa.pay.model.DictionaryItem;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Configuration
public class ServerConfiguration {

    @Autowired
    private PayAccountRepository payAccountRepository;

    @Autowired
    private PayAppRepository payAppRepository;

    @Autowired
    private PayFeatureRepository payFeatureRepository;

    @Autowired
    private MchChannelRepository mchChannelRepository;

    @Autowired
    private DictionaryRepository dictionaryRepository;

    public AcquirerBuilder acquirerBuilder() {
        List<PayAccountEntity> accounts = payAccountRepository.findAll();
        List<PayFeatureEntity> features = payFeatureRepository.findAll();
        List<PayAppEntity> apps = payAppRepository.findAll();

        AcquirerBuilder builder = new AcquirerBuilder();
        builder.accounts(accounts)
                .features(features)
                .apps(apps);

        accounts.clear();
        features.clear();
        apps.clear();
        return builder;
    }

    @Bean
    public DictionaryViewer dictionaryViewer() {
        DictionaryViewer dictionary = new DictionaryViewer();
        List<DictionaryEntity> entities = dictionaryRepository.findAll();
        for (DictionaryEntity entity : entities) {
            DictionaryItem item = new DictionaryItem();
            item.setName(entity.getName());
            item.setCode(entity.getCode());
            item.setType(entity.getType());
            item.setImageUrl(entity.getImageUrl());
            dictionary.add(item);
        }
        return dictionary;
    }

    @Bean
    public MerchantAcquirerBuilder merchantAcquirerBuilder() {
        AcquirerBuilder acquirerBuilder = acquirerBuilder();
        List<MchChannelEntity> entities = mchChannelRepository.findAll();
        MerchantAcquirerBuilder builder = acquirerBuilder.build(entities);
        acquirerBuilder.release();
        entities.clear();
        return builder;
    }
}
