package cn.quant.baa.pay.service;

import cn.quant.baa.pay.acquirer.AcquirerProperties;
import cn.quant.baa.pay.model.web.MerchantAcquirerProperties;
import cn.quant.baa.pay.model.web.MerchantChannelResponseData;
import cn.quant.baa.pay.model.web.MerchantChannelRequestData;
import cn.quant.baa.pay.acquirer.AcquirerConfiguration;
import cn.quant.baa.pay.model.ModelBuilder;
import cn.quant.spring.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Service
public class MerchantService {
    @Autowired
    private AcquirerConfiguration acquirerConfiguration;

    @Autowired
    private ModelBuilder modelBuilder;


//    @Cacheable(cacheManager = "profileCacheManager"
//            , cacheNames = "LOCAL_PROFILE"
//            , key = "#requestData.persistenceKey()")
    public Map<String, MerchantChannelResponseData> getChannels(MerchantChannelRequestData requestData) {
        String mchId = requestData.getMchId();
        String channel = requestData.getChannel();
        Map<String, Collection<AcquirerProperties>> profiles;

        if (StringUtils.isEmpty(channel)) {
            profiles = acquirerConfiguration.get(mchId);
        } else {
            profiles = acquirerConfiguration.get(mchId, channel);
        }

        Map<String, MerchantChannelResponseData> response = modelBuilder.toModel(profiles, requestData.getAccess());
        return response;
    }

    public MerchantAcquirerProperties getChannel(MerchantChannelRequestData requestData) {
        return getChannel(Long.parseLong(requestData.getChanId()));
    }

    @Cacheable(cacheManager = "profileCacheManager"
            , cacheNames = "LOCAL_PROFILE"
            , key = "#id")
    public MerchantAcquirerProperties getChannel(Long id) {
        AcquirerProperties profile = acquirerConfiguration.get(id);
        return modelBuilder.toModel(profile);
    }
}
