package cn.quant.baa.pay.model.web;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 * Author: Lipeng Liu
 * Date: 2021/9/8
 * Time: 上午11:30
 * Description: No Description
 */
public class RefundRequestData implements Serializable {

    private static final long serialVersionUID = -3619831737213449288L;

    /**
     * 支付通道ID
     */
    @NotNull(message = "ILLEGAL_REQ_CHAN_ID")
    private String chanId;

    /**
     * 退款订单号
     */
    @Size(min = 6, max = 64, message = "ILLEGAL_REQ_OUT_REFUND_NO")
    @NotNull(message = "ILLEGAL_REQ_OUT_REFUND_NO")
    private String outRefundNo;

    /**
     * 商户订单号
     */
    @Size(min = 6, max = 64, message = "ILLEGAL_REQ_OUT_TRADE_NO")
    @NotNull(message = "ILLEGAL_REQ_OUT_TRADE_NO")
    private String outTradeNo;

    /**
     * 退款原因
     */
    @NotNull(message = "ILLEGAL_REQ_REFUND_REASON")
    private String refundReason;

    /**
     * 退款金额
     */
    @NotNull(message = "ILLEGAL_REQ_REFUND_AMOUNT")
    private String refundAmount;


    public String getChanId() {
        return chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public String getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }
}
