package cn.quant.baa.pay.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

import static cn.quant.baa.pay.Constant.NAMESPACE_LOCAL_CACHE_TRANSACTION;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Configuration
@EnableCaching
public class LocalCacheConfiguration {

    @Value("${quant.baapay.local-cache-expire.time}")
    private Integer expireTime;

    @Value("${quant.baapay.local-cache-expire.unit}")
    private TimeUnit expireUnit;

    @Value("${quant.baapay.local-cache-expire.size}")
    private Integer expireSize;

    @Bean
    public CacheManager profileCacheManager() {
        //TODO:reload cached data
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.registerCustomCache("LOCAL_PROFILE",
                Caffeine.newBuilder()
                        .expireAfterWrite(expireTime, expireUnit)
                        .maximumSize(expireSize == null ? 500 : expireSize)
                        .build());
        return cacheManager;
    }
}
