package cn.quant.baa.pay.config;

import cn.quant.spring.boot.config.WebMessageConfigurer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

/**
 * Created by hechao on 2018/6/28.
 */
@Configuration
public class WebMvcConfiguration extends WebMessageConfigurer {

    @Bean
    public MappingJackson2HttpMessageConverter httpMessageConverter() {

        MappingJackson2HttpMessageConverter converter = super.httpMessageConverter();
        ObjectMapper objectMapper = converter.getObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return converter;
    }
}

