package cn.quant.baa.pay.model.web;

import cn.quant.baa.pay.model.BusinessRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 * Author: Lipeng Liu
 * Date: 2021/9/8
 * Time: 上午11:05
 * Description: No Description
 */
public class CheckRefundRequestData extends BusinessRequest implements Serializable {

    private static final long serialVersionUID = 4652001398076281697L;

    /**
     * 支付通道ID
     */
    @NotNull(message = "ILLEGAL_REQ_CHAN_ID")
    private String chanId;

    /**
     * 退款订单号
     */
    @Size(min = 6, max = 64, message = "ILLEGAL_REQ_OUT_REFUND_NO")
    @NotNull(message = "ILLEGAL_REQ_OUT_REFUND_NO")
    private String outRefundNo;

    /**
     * 商户订单号
     */
    @Size(min = 6, max = 64, message = "ILLEGAL_REQ_OUT_TRADE_NO")
    @NotNull(message = "ILLEGAL_REQ_OUT_TRADE_NO")
    private String outTradeNo;


    public String getChanId() {
        return chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }
}
