package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.CreditDebitFlag;
import cn.quant.baa.pay.dict.CurrencyCode;
import cn.quant.baa.pay.dict.PayMethod;
import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.spring.data.jpa.entity.DescribablePartitionEntity;
import cn.quant.spring.util.StringUtils;
import org.hibernate.annotations.Type;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/26 0026.
 */
@Entity
@Table(name = "transaction_summary")
public class TransactionSummaryEntity extends DescribablePartitionEntity implements Serializable {

    private static final long serialVersionUID = 6297586921507136281L;

    private static final String CLASS_NAME = TransactionSummaryEntity.class.getSimpleName();

    @Column(name = "TRANSACTION_ID", nullable = false, updatable = false)
    private Long transactionId;

    @Id
    @Column(name = "CHECK_CODE", nullable = false, updatable = false, length = 32)
    private String checkCode;

    @Column(name = "INSTITUTION_ID", nullable = false, updatable = false, length = 4)
    private String institutionId;

    @Column(name = "PRODUCT_ID", nullable = false, updatable = false, length = 4)
    private String productId;

    @Column(name = "EXTERNAL_ORDER_NO", nullable = false, updatable = false, length = 64)
    private String externalOrderNo;


    @Column(name = "GEN_ORDER_NO", nullable = false, updatable = false, length = 64)
    private String genOrderNo;

    @Column(name = "ACCOUNT_ID", nullable = false, updatable = false)
    private Long accountId;

    @Column(name = "CHANNEL_ID", nullable = false, updatable = false)
    private Long channelId;

    @Column(name = "SUBJECT", nullable = false, updatable = false, length = 128)
    private String subject;

    @Enumerated(EnumType.STRING)
    @Column(name = "STATUS_CODE", nullable = false, length = 4)
    private StatusCode statusCode;

    @Enumerated(EnumType.STRING)
    @Column(name = "CURRENCY_CODE", nullable = false, updatable = false, length = 3)
    private CurrencyCode currencyCode;

    @Enumerated(EnumType.STRING)
    @Column(name = "PAY_METHOD", nullable = false, updatable = false, length = 4)
    private PayMethod payMethod;

    @Column(name = "TXN_TYPE", nullable = false, updatable = false, length = 4)
    private String txnType;

    @Column(name = "TXN_CODE", nullable = false, updatable = false, length = 4)
    private String txnCode;

    @Column(name = "TXN_NO", nullable = false, updatable = false)
    private Integer txnNo;

    @Column(name = "STATISTICS_CODE", nullable = false, updatable = false, length = 4)
    private String statisticsCode;

    @Enumerated(EnumType.STRING)
    @Column(name = "CREDIT_DEBIT_FLAG", nullable = false, updatable = false, length = 1)
    private CreditDebitFlag creditDebitFlag;

    @Type(type = "yes_no")
    @Column(name = "CUSTOMER_GEN_FLAG", nullable = false, updatable = false, length = 1)
    private Boolean customerGenFlag;

    @Column(name = "ORIGINAL_TXN_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal originalTxnAmount;

    @Column(name = "TXN_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal txnAmount;

    @Column(name = "DISC_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal discAmount;

    @Column(name = "GEN_FEE_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal genFeeAmount;

    @Column(name = "POST_CASH_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal postCashAmount;

    @Column(name = "POST_CREDIT_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal postCreditAmount;

    @Column(name = "STATEMENTE_FLAG", nullable = false, updatable = false, length = 1)
    private Boolean statementeFlag;

    @Column(name = "TXN_DATE", nullable = false, updatable = false)
    private LocalDate txnDate;

    @Column(name = "TXN_TIME", nullable = false, updatable = false)
    private LocalTime txnTime;

    @Column(name = "PAY_DUE_TIME", nullable = false, updatable = false)
    private LocalDateTime payDueTime;

    @Column(name = "REQUEST_ID", nullable = false, updatable = false, length = 64)
    private String requestId;

    @Column(name = "REQUEST_TIME", nullable = false, updatable = false)
    private Date requestTime;

    @Column(name = "SHOP_NAME", nullable = true, length = 255)
    private String shopName;

    @Column(name = "MOBILE_PHONE", nullable = true, length = 13)
    private String mobilePhone;

    @Column(name = "GOODS_SIGNER", nullable = true, length = 60)
    private String goodsSigner;

    @Column(name = "ADDRESS", nullable = true, length = 500)
    private String address;

    @Column(name = "ATTACH_TEXT", nullable = true, length = 512)
    private String attachText;

    public Long getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getGenOrderNo() {
        return genOrderNo;
    }

    public void setGenOrderNo(String genOrderNo) {
        this.genOrderNo = genOrderNo;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public StatusCode getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PayMethod getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(PayMethod payMethod) {
        this.payMethod = payMethod;
    }

    public String getTxnType() {
        return txnType;
    }

    public void setTxnType(String txnType) {
        this.txnType = txnType;
    }

    public String getTxnCode() {
        return txnCode;
    }

    public void setTxnCode(String txnCode) {
        this.txnCode = txnCode;
    }

    public Integer getTxnNo() {
        return txnNo;
    }

    public void setTxnNo(Integer txnNo) {
        this.txnNo = txnNo;
    }

    public String getStatisticsCode() {
        return statisticsCode;
    }

    public void setStatisticsCode(String statisticsCode) {
        this.statisticsCode = statisticsCode;
    }

    public CreditDebitFlag getCreditDebitFlag() {
        return creditDebitFlag;
    }

    public void setCreditDebitFlag(CreditDebitFlag creditDebitFlag) {
        this.creditDebitFlag = creditDebitFlag;
    }

    public Boolean getCustomerGenFlag() {
        return customerGenFlag;
    }

    public void setCustomerGenFlag(Boolean customerGenFlag) {
        this.customerGenFlag = customerGenFlag;
    }

    public BigDecimal getOriginalTxnAmount() {
        return originalTxnAmount;
    }

    public void setOriginalTxnAmount(BigDecimal originalTxnAmount) {
        this.originalTxnAmount = originalTxnAmount;
    }

    public BigDecimal getTxnAmount() {
        return txnAmount;
    }

    public void setTxnAmount(BigDecimal txnAmount) {
        this.txnAmount = txnAmount;
    }

    public BigDecimal getDiscAmount() {
        return discAmount;
    }

    public void setDiscAmount(BigDecimal discAmount) {
        this.discAmount = discAmount;
    }

    public BigDecimal getGenFeeAmount() {
        return genFeeAmount;
    }

    public void setGenFeeAmount(BigDecimal genFeeAmount) {
        this.genFeeAmount = genFeeAmount;
    }

    public BigDecimal getPostCashAmount() {
        return postCashAmount;
    }

    public void setPostCashAmount(BigDecimal postCashAmount) {
        this.postCashAmount = postCashAmount;
    }

    public BigDecimal getPostCreditAmount() {
        return postCreditAmount;
    }

    public void setPostCreditAmount(BigDecimal postCreditAmount) {
        this.postCreditAmount = postCreditAmount;
    }

    public Boolean getStatementeFlag() {
        return statementeFlag;
    }

    public void setStatementeFlag(Boolean statementeFlag) {
        this.statementeFlag = statementeFlag;
    }

    public LocalDate getTxnDate() {
        return txnDate;
    }

    public void setTxnDate(LocalDate txnDate) {
        this.txnDate = txnDate;
    }

    public LocalTime getTxnTime() {
        return txnTime;
    }

    public void setTxnTime(LocalTime txnTime) {
        this.txnTime = txnTime;
    }

    public LocalDateTime getPayDueTime() {
        return payDueTime;
    }

    public void setPayDueTime(LocalDateTime payDueTime) {
        this.payDueTime = payDueTime;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Date getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getGoodsSigner() {
        return goodsSigner;
    }

    public void setGoodsSigner(String goodsSigner) {
        this.goodsSigner = goodsSigner;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAttachText() {
        return attachText;
    }

    public void setAttachText(String attachText) {
        this.attachText = attachText;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, institutionId, productId, externalOrderNo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TransactionSummaryEntity that = (TransactionSummaryEntity) o;
        return Objects.equals(institutionId, that.institutionId) &&
                Objects.equals(productId, that.productId) &&
                Objects.equals(externalOrderNo, that.externalOrderNo);
    }


    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("TransactionSummaryEntity{");
        sb.append("transactionId=").append(transactionId);
        sb.append(", checkCode='").append(checkCode).append('\'');
        sb.append(", institutionId='").append(institutionId).append('\'');
        sb.append(", productId='").append(productId).append('\'');
        sb.append(", externalOrderNo='").append(externalOrderNo).append('\'');
        sb.append(", genOrderNo='").append(genOrderNo).append('\'');
        sb.append(", accountId=").append(accountId);
        sb.append(", channelId=").append(channelId);
        sb.append(", subject='").append(subject).append('\'');
        sb.append(", statusCode=").append(statusCode);
        sb.append(", currencyCode=").append(currencyCode);
        sb.append(", payMethod=").append(payMethod);
        sb.append(", txnType='").append(txnType).append('\'');
        sb.append(", txnCode='").append(txnCode).append('\'');
        sb.append(", txnNo=").append(txnNo);
        sb.append(", statisticsCode='").append(statisticsCode).append('\'');
        sb.append(", creditDebitFlag=").append(creditDebitFlag);
        sb.append(", customerGenFlag=").append(customerGenFlag);
        sb.append(", originalTxnAmount=").append(originalTxnAmount);
        sb.append(", txnAmount=").append(txnAmount);
        sb.append(", discAmount=").append(discAmount);
        sb.append(", genFeeAmount=").append(genFeeAmount);
        sb.append(", postCashAmount=").append(postCashAmount);
        sb.append(", postCreditAmount=").append(postCreditAmount);
        sb.append(", statementeFlag=").append(statementeFlag);
        sb.append(", txnDate=").append(txnDate);
        sb.append(", txnTime=").append(txnTime);
        sb.append(", payDueTime=").append(payDueTime);
        sb.append(", requestId='").append(requestId).append('\'');
        sb.append(", requestTime=").append(requestTime);
        sb.append(", shopName='").append(shopName).append('\'');
        sb.append(", mobilePhone='").append(mobilePhone).append('\'');
        sb.append(", goodsSigner='").append(goodsSigner).append('\'');
        sb.append(", address='").append(address).append('\'');
        sb.append(", attachText='").append(attachText).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
