package cn.quant.baa.pay.config;

import cn.quant.baa.pay.model.dto.DictionaryItemDTO;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;

import java.util.Map;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
public class DictionaryViewer {

    private Table<String, String, DictionaryItemDTO> bigTable = Tables.newCustomTable(Maps.newHashMap(), new Supplier() {
        public Map<String, DictionaryItemDTO> get() {
            return Maps.newLinkedHashMap();
        }
    });

    private final static DictionaryViewer viewer = new DictionaryViewer();

    private DictionaryViewer() {
    }

    public static DictionaryViewer getInstance() {
        return viewer;
    }

    public static void add(DictionaryItemDTO item) {
        viewer.bigTable.put(item.getType(), item.getCode(), item);
    }

    public static DictionaryItemDTO get(String type, String code) {
        return viewer.bigTable.get(type, code);
    }


}
