package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.jpa.entity.PayHistoryEntity;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.model.web.CheckPayRequestData;
import cn.quant.baa.pay.model.web.PayRequestData;
import cn.quant.baa.pay.service.TransactionService;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.web.bind.annotation.*;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@RestController
@RequestMapping("/transaction")
public class TransactionController extends BusinessController {

    @Autowired
    private TransactionService transactionService;

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/pay")
    public JsonNode pay(@RequestBody BusinessRequest<PayRequestData> request) {

        PayRequestData data = request.getData();
        JsonNode res = transactionService.pay(data);

        System.currentTimeMillis();
        return res;
    }

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/checkPay")
    public JsonNode checkPay(@RequestBody BusinessRequest<CheckPayRequestData> request) {

        CheckPayRequestData data = request.getData();
        JsonNode res = transactionService.checkPay(data);

        System.currentTimeMillis();
        return res;
    }

}
