package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.spring.data.jpa.entity.PartitionEntity;
import cn.quant.spring.util.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * Created by Administrator on 2021/9/22 0022.
 */
@Entity
@Table(name = "batch_cycle_trigger")
public class BatchCycleTriggerEntity extends PartitionEntity implements Serializable {

    private static final long serialVersionUID = 1419514603248200095L;

    public final static String CLASS_NAME = BatchCycleTriggerEntity.class.getSimpleName();

    @Id
    @Column(name = "TRIGGER_ID", nullable = false)
    private long triggerId;

    @Column(name = "ENTITY_CODE", nullable = false, length = 4)
    private String entityCode;

    @Column(name = "TARGET_ID", nullable = false)
    private Long targetId;

    @Column(name = "ACCOUNT_ID", nullable = false)
    private Long accountId;

    @Column(name = "PAY_DUE_TIME", nullable = false)
    private LocalDateTime payDueTime;

    @Column(name = "NOTIFY_URL", nullable = true, length = 1000)
    private String notifyUrl;

    @Enumerated(EnumType.STRING)
    @Column(name = "CHAN_NOTIFY_STATUS", nullable = false, length = 4)
    private StatusCode chanNotifyStatus;

    @Column(name = "CHAN_NOTIFY_TIME", nullable = true)
    private Date chanNotifyTime;

    @Enumerated(EnumType.STRING)
    @Column(name = "MCH_NOTIFY_STATUS", nullable = false, length = 4)
    private StatusCode mchNotifyStatus;

    @Column(name = "MCH_NOTIFY_TIME", nullable = true)
    private Date mchNotifyTime;

    @Column(name = "REQUEST_ID", nullable = true, length = 64)
    private String  requestId;

    public long getTriggerId() {
        return triggerId;
    }

    public void setTriggerId(long triggerId) {
        this.triggerId = triggerId;
    }

    public String getEntityCode() {
        return entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public LocalDateTime getPayDueTime() {
        return payDueTime;
    }

    public void setPayDueTime(LocalDateTime payDueTime) {
        this.payDueTime = payDueTime;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public StatusCode getChanNotifyStatus() {
        return chanNotifyStatus;
    }

    public void setChanNotifyStatus(StatusCode chanNotifyStatus) {
        this.chanNotifyStatus = chanNotifyStatus;
    }

    public Date getChanNotifyTime() {
        return chanNotifyTime;
    }

    public void setChanNotifyTime(Date chanNotifyTime) {
        this.chanNotifyTime = chanNotifyTime;
    }

    public StatusCode getMchNotifyStatus() {
        return mchNotifyStatus;
    }

    public void setMchNotifyStatus(StatusCode mchNotifyStatus) {
        this.mchNotifyStatus = mchNotifyStatus;
    }

    public Date getMchNotifyTime() {
        return mchNotifyTime;
    }

    public void setMchNotifyTime(Date mchNotifyTime) {
        this.mchNotifyTime = mchNotifyTime;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, triggerId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BatchCycleTriggerEntity that = (BatchCycleTriggerEntity) o;
        return triggerId == that.triggerId;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BatchCycleTriggerEntity{");
        sb.append("triggerId=").append(triggerId);
        sb.append(", entityCode='").append(entityCode).append('\'');
        sb.append(", targetId=").append(targetId);
        sb.append(", accountId=").append(accountId);
        sb.append(", payDueTime=").append(payDueTime);
        sb.append(", notifyUrl='").append(notifyUrl).append('\'');
        sb.append(", chanNotifyStatus=").append(chanNotifyStatus);
        sb.append(", chanNotifyTime=").append(chanNotifyTime);
        sb.append(", mchNotifyStatus=").append(mchNotifyStatus);
        sb.append(", mchNotifyTime=").append(mchNotifyTime);
        sb.append(", requestId='").append(requestId).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
