package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.acquirer.AcquirerProperties;
import cn.quant.baa.pay.acquirer.AcquirerPropertiesSource;
import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.config.DictionaryViewer;
import cn.quant.baa.pay.model.dto.DictionaryItemDTO;
import cn.quant.spring.ProfileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

import static cn.quant.baa.pay.Constant.DICT_CODE_WXP;
import static cn.quant.baa.pay.Constant.DICT_TYPE_PAY;

/**
 * Created by Administrator on 2021/9/26 0026.
 */
@RestController
@RequestMapping("/transaction")
public class TransactionController extends BusinessController {

    private static final Logger logger = LoggerFactory.getLogger(TransactionController.class);

    @Autowired
    private AcquirerPropertiesSource acquirerPropertiesSource;


    @ResponseBody
    @BusinessMapping
    @PostMapping("/pay/callback/wx/{chanId}")
    public ResponseEntity pay(@PathVariable("chanId") String chanId, @RequestBody Map request) throws Exception {

        logger.info(request.toString());

        DictionaryItemDTO dict = DictionaryViewer.get(DICT_TYPE_PAY, DICT_CODE_WXP);
        if (dict == null) {
            throw new ProfileException("Configuration not found in dictionary : {}; {}; {}; {};", DICT_TYPE_PAY, DICT_CODE_WXP, chanId, request);
        }

        AcquirerProperties properties = acquirerPropertiesSource.get(Long.valueOf(chanId));
        if (properties == null || !dict.getCode().equals(properties.getPayChanCode())) {
            throw new ProfileException("Acquirer not found : {}; {}; {}; {};", DICT_TYPE_PAY, DICT_CODE_WXP, chanId, request);
        }


//        CallbackRequestData requestData = new CallbackRequestData();
//        requestData.setChanId(chanId);

//        transactionService.callback(requestData);
        return null;
    }
}
