package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.OptimisticEntity;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Entity
@Table(name = "dictionary")
public class DictionaryEntity extends OptimisticEntity implements Serializable {

    private static final long serialVersionUID = -4339755594508649928L;
    @EmbeddedId
    private DictionaryIds ids;

    @Column(name = "ID", nullable = false, updatable = false)
    private Long id;

    @Column(name = "TEXT", nullable = false, length = 64)
    private String text;

    @Column(name = "VALUE", nullable = false, length = 500)
    private String value;

    @Column(name = "IMAGE_URL", nullable = true, length = 500)
    private String imageUrl;

    @Column(name = "PARENT_ID", nullable = true, length = 500)
    private Integer parentId;

    public DictionaryIds getIds() {
        return ids;
    }

    public void setIds(DictionaryIds ids) {
        this.ids = ids;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getParentId() {
        return parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getPersistentKey() {
        return ids.getPersistentKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DictionaryEntity that = (DictionaryEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("DictionaryEntity{");
        sb.append("ids=").append(ids);
        sb.append(", id=").append(id);
        sb.append(", text='").append(text).append('\'');
        sb.append(", value='").append(value).append('\'');
        sb.append(", imageUrl='").append(imageUrl).append('\'');
        sb.append(", parentId=").append(parentId);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    public String getType(){
        return ids.getType();
    }

    public String getCode(){
        return ids.getCode();
    }


}
