package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.PartitionEntity;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/30 0030.
 */
@Entity
@Table(name = "pay_goods_detail")
public class PayGoodsDetailEntity extends PartitionEntity implements Serializable {

    public final static String CLASS_NAME = PayGoodsDetailEntity.class.getSimpleName();
    private static final long serialVersionUID = -2783909112856789454L;

    @Id
    @Column(name = "GOODS_ID", nullable = false, updatable = false)
    private Long goodsId;

    @Column(name = "TRANSACTION_ID", nullable = false, updatable = false)
    private Long transactionId;

    @Column(name = "GOODS_ORDER_NO", nullable = false, updatable = false, length = 64)
    private String goodsOrderNo;

    @Column(name = "GOODS_NAME", nullable = false, updatable = false, length = 512)
    private String goodsName;

    @Column(name = "QUANTITY", nullable = false, updatable = false)
    private Integer quantity;

    @Column(name = "PRICE", nullable = false, updatable = false, precision = 2)
    private BigDecimal price;

    @Column(name = "DISC_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal discAmount;

    @Column(name = "TXN_AMOUNT", nullable = false, updatable = false, precision = 2)
    private BigDecimal txnAmount;

    @Column(name = "ATTACH_TEXT", nullable = true, length = 512)
    private String attachText;

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public Long getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public String getGoodsOrderNo() {
        return goodsOrderNo;
    }

    public void setGoodsOrderNo(String goodsOrderNo) {
        this.goodsOrderNo = goodsOrderNo;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getDiscAmount() {
        return discAmount;
    }

    public void setDiscAmount(BigDecimal discAmount) {
        this.discAmount = discAmount;
    }

    public BigDecimal getTxnAmount() {
        return txnAmount;
    }

    public void setTxnAmount(BigDecimal txnAmount) {
        this.txnAmount = txnAmount;
    }

    public String getAttachText() {
        return attachText;
    }

    public void setAttachText(String attachText) {
        this.attachText = attachText;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, goodsId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayGoodsDetailEntity that = (PayGoodsDetailEntity) o;
        return Objects.equals(goodsId, that.goodsId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayGoodsDetailEntity{");
        sb.append("goodsId=").append(goodsId);
        sb.append(", transactionId=").append(transactionId);
        sb.append(", goodsOrderNo='").append(goodsOrderNo).append('\'');
        sb.append(", goodsName='").append(goodsName).append('\'');
        sb.append(", quantity=").append(quantity);
        sb.append(", price=").append(price);
        sb.append(", discAmount=").append(discAmount);
        sb.append(", txnAmount=").append(txnAmount);
        sb.append(", attachText='").append(attachText).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
