package cn.quant.baa.pay.service;

import cn.quant.baa.pay.config.LocalCacheConfiguration;
import cn.quant.baa.pay.jpa.entity.StatusCodeEntity;
import cn.quant.baa.pay.jpa.entity.StatusCodeIds;
import cn.quant.baa.pay.model.dto.StatusCodeDTO;
import cn.quant.spring.data.jpa.PersistentEntityInvoker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2021/9/18 0018.
 */
@Service
public class ProfileStorageService {

    @Autowired
    private PersistentEntityInvoker persistentEntityInvoker;

    @Cacheable(cacheManager = LocalCacheConfiguration.LOCAL_CACHE_MANAGER
            , cacheNames = LocalCacheConfiguration.LOCAL_CACHE_PROFILE
            , key = "#ids.persistentKey")
    public StatusCodeDTO getStatusCode(StatusCodeIds ids) throws Exception {
        StatusCodeDTO code = persistentEntityInvoker.Invoke(ids, StatusCodeEntity.class, StatusCodeDTO.class);
        return code;
    }

}
