package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.PrimaryIds;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Embeddable
public class DictionaryIds extends PrimaryIds implements Serializable {

    private static final long serialVersionUID = 7804804141804874320L;

    private final static String CLASS_NAME = DictionaryEntity.class.getSimpleName();

    @Column(name = "TYPE", nullable = false, updatable = false, length = 32)
    private String type;

    @Column(name = "CODE", nullable = false, updatable = false, length = 32)
    private String code;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, type, code);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DictionaryIds that = (DictionaryIds) o;
        return Objects.equals(type, that.type) &&
                Objects.equals(code, that.code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(CLASS_NAME, type, code);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("DictionaryIds{");
        sb.append("type='").append(type).append('\'');
        sb.append(", code='").append(code).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
