package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.spring.data.jpa.entity.DescriptionEntity;
import org.hibernate.annotations.Type;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Objects;

/**
 * Created by Administrator on 2021/9/13 0013.
 */
@Entity
@Table(name = "status_code")
public class StatusCodeEntity extends DescriptionEntity {

    private static final long serialVersionUID = -247953772558454731L;

    @EmbeddedId
    private StatusCodeIds ids;

    @Column(name = "PRIORITY", nullable = false)
    private Integer priority;

    @Column(name = "CODE_TYPE", nullable = false, length = 4)
    private String codeType;

    @Column(name = "POSTING_CODE", nullable = false, length = 4)
    private String postingCode;

    @Type(type = "yes_no")
    @Column(name = "SEND_NOTICE_FLAG", nullable = false, length = 1)
    private Boolean sendNoticeFlag;

    @Column(name = "REGR_CODE", nullable = true, length = 4)
    private StatusCode regrCode;

    @Column(name = "FAILED_CODE", nullable = false, length = 4)
    private StatusCode failedCode;

    @Column(name = "NEXT_CODE", nullable = true, length = 4)
    private StatusCode nextCode;

    @Column(name = "MESSAGE_CODE", nullable = true, length = 4)
    private String messageCode;

    public StatusCodeIds getIds() {
        return ids;
    }

    public void setIds(StatusCodeIds ids) {
        this.ids = ids;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getCodeType() {
        return codeType;
    }

    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    public String getPostingCode() {
        return postingCode;
    }

    public void setPostingCode(String postingCode) {
        this.postingCode = postingCode;
    }

    public Boolean getSendNoticeFlag() {
        return sendNoticeFlag;
    }

    public void setSendNoticeFlag(Boolean sendNoticeFlag) {
        this.sendNoticeFlag = sendNoticeFlag;
    }

    public StatusCode getRegrCode() {
        return regrCode;
    }

    public void setRegrCode(StatusCode regrCode) {
        this.regrCode = regrCode;
    }

    public StatusCode getFailedCode() {
        return failedCode;
    }

    public void setFailedCode(StatusCode failedCode) {
        this.failedCode = failedCode;
    }

    public StatusCode getNextCode() {
        return nextCode;
    }

    public void setNextCode(StatusCode nextCode) {
        this.nextCode = nextCode;
    }

    public String getMessageCode() {
        return messageCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public String getInstitutionId(){
        return this.ids.getInstitutionId();
    }

    public String getEntity(){
        return this.ids.getEntity();
    }

    public StatusCode getCode(){
        return this.ids.getCode();
    }

    @Override
    public String getPersistentKey() {
        return ids.getPersistentKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StatusCodeEntity that = (StatusCodeEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("StatusCodeEntity{");
        sb.append("ids=").append(ids);
        sb.append(", priority=").append(priority);
        sb.append(", codeType='").append(codeType).append('\'');
        sb.append(", postingCode='").append(postingCode).append('\'');
        sb.append(", sendNoticeFlag=").append(sendNoticeFlag);
        sb.append(", regrCode='").append(regrCode).append('\'');
        sb.append(", failedCode='").append(failedCode).append('\'');
        sb.append(", nextCode='").append(nextCode).append('\'');
        sb.append(", messageCode='").append(messageCode).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
