package cn.quant.baa.pay.model.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
public class MerchantChannelResponseData implements Serializable {
    private static final long serialVersionUID = -7479646457077040392L;

    private String code;

    private String name;

    private String imageUrl;

    private Map<String, MerchantAcquirerProperties> acquirers;

    public MerchantChannelResponseData() {
        acquirers = new HashMap<String, MerchantAcquirerProperties>();
    }

    public Map<String, MerchantAcquirerProperties> getAcquirers() {
        return acquirers;
    }

    public void add(MerchantAcquirerProperties acquirer) {
        acquirers.put(acquirer.getAccessCode(), acquirer);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("MerchantChannelResponseData{");
        sb.append("code='").append(code).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", imageUrl='").append(imageUrl).append('\'');
        sb.append(", acquirers=").append(acquirers);
        sb.append('}');
        return sb.toString();
    }
}
