package cn.quant.baa.pay.acquirer;

import cn.quant.spring.security.Base64Cipher;
import cn.quant.spring.security.CharacterCipher;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/31 0031.
 */
public abstract class MerchantAcquirer implements Acquirer {

    private static Map<Object, Acquirer> acquirers = new HashMap<>();

    protected Cipher cipher;

    protected SecretKeySpec secretKey;

    protected CharacterCipher secretCipher;

    private AcquirerProperties properties;

    public MerchantAcquirer init(AcquirerProperties properties) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {

        this.secretCipher = new Base64Cipher();
        String secretType = properties.getSecretType();
        if (secretType.startsWith("AES")) {
            this.secretKey = new SecretKeySpec(properties.getSecretKey().getBytes(), "AES");
        }
        this.cipher = Cipher.getInstance(secretType);
        this.cipher.init(Cipher.ENCRYPT_MODE, this.secretKey);

        this.properties = properties;

        return this;
    }

    public static void register(Acquirer acquirer) {
        acquirers.put(acquirer.code(), acquirer);
    }

}
