package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.acquirer.AcquirerProperties;
import cn.quant.baa.pay.acquirer.ChannelResponse;
import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.component.Sequencer;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.model.web.CheckPayRequestData;
import cn.quant.baa.pay.model.web.CheckRefundRequestData;
import cn.quant.baa.pay.model.web.PayRequestData;
import cn.quant.baa.pay.service.TransactionService;
import cn.quant.spring.context.ServerApplicationContext;
import cn.quant.spring.http.HttpResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * Created with IntelliJ IDEA.
 * Author: Lipeng Liu
 * Date: 2021/9/9
 * Time: 上午9:51
 * Description: No Description
 */
@Controller
//@RestController
@RequestMapping("pay")
public class PayTestController extends BusinessController {

    @Autowired
    private TransactionService transactionService;

    @Autowired
    private ServerApplicationContext serverApplicationContext;

    @Autowired
    private Sequencer sequencer;

    @GetMapping("")
    public String getPay(Model model) {
        return "pay/index";
    }

    @RequestMapping("h5")
    public String getH5(Model model) {
        return "pay/h5";
    }

    @RequestMapping("ipv4")
    public String ipv4(HttpServletRequest request) {
        return "var CLIENT_IP=\"" + getClientAddress(request) + "\"";
    }

    @RequestMapping("checkPay")
    public String checkPay(CheckPayRequestData data, Model model, HttpServletRequest servletRequest) throws Exception {
        String res = "";
        if (servletRequest.getMethod().equals("POST")) {
            res = transactionService.checkPay(data).toString();
        }
        model.addAttribute("res", res);
        return "pay/checkPay";
    }

    @RequestMapping("checkRefund")
    public String checkRefund(CheckRefundRequestData data, Model model, HttpServletRequest servletRequest) throws Exception {

        String res = "";
        if (servletRequest.getMethod().equals("POST")) {
            res = transactionService.checkRefund(data).toString();
        }
        model.addAttribute("res", res);
        return "pay/checkRefund";
    }


    @PostMapping("goPay")
    @BusinessMapping(session = 1)
    @ResponseBody
    public ResponseEntity goPay(@RequestBody(required = false) BusinessRequest<PayRequestData> requestData) throws Exception {
        PayRequestData data = requestData.getData();
        String str = "{\"subject\":\"测试订单1\",\"chanId\":\"75772285618946307\",\"outTradeNo\":\"11111111223\",\"originalAmount\":\"110.00\",\"amount\":0.01,\"discounts\":\"10.00\",\"notifyUrl\":\"http://127.0.0.1:8080/notifyUrl\",\"buyerId\":\"777777\",\"attach\":\"AAAA-BBBB-1111-2222\",\"creditAmount\":\"10.00\",\"cashAmount\":\"10\",\"goodsDetail\":[{\"goodsNo\":\"123123\",\"goodsId\":\"11111\",\"goodsName\":\"商品1\",\"quantity\":2,\"price\":\"10.00\",\"discounts\":\"2.5\",\"amount\":\"17.5\",\"attach\":\"---\",\"creditAmount\":123,\"cashAmount\":123}]}";
        PayRequestData payRequestData = objectMapper.readValue(str, PayRequestData.class);
        String chanId = data.getChanId();
        payRequestData.setChanId(chanId);
        payRequestData.setOutTradeNo(data.getOutTradeNo());
        payRequestData.setAccountNo(data.getAccountNo());
        payRequestData.setSubject(data.getSubject());
        payRequestData.setAmount(data.getAmount());
        payRequestData.setNotifyUrl(data.getNotifyUrl());
        payRequestData.setRequestIp(requestData.getRequestIp());
        AcquirerProperties properties = check(payRequestData);
        ChannelResponse response = transactionService.pay(properties, payRequestData);
        HttpResponseData responseData = response(response);
        return ResponseEntity.ok(responseData);

    }

}