package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.spring.rest.AbstractController;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradePagePayModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import org.springframework.web.bind.annotation.*;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;
import java.util.UUID;

/**
 * Created with IntelliJ IDEA.
 * Author: Lipeng Liu
 * Date: 2021/8/31
 * Time: 上午10:36
 * Description: No Description
 */
@RestController
@RequestMapping("alipay")
public class AlipayController extends AbstractController {

    @ResponseBody
    @GetMapping("/h5")
    public String h5() {
        try {
            // 1. 创建AlipayClient实例
            AlipayClient alipayClient = new DefaultAlipayClient(getClientParams());
            // 2. 创建使用的Open API对应的Request请求对象
            AlipayTradeWapPayRequest request = getRequestH5();
            // 3. 发起请求并处理响应
            AlipayTradeWapPayResponse response = alipayClient.pageExecute(request);
            if (response.isSuccess()) {
                System.out.println("调用成功。");
                return response.getBody();
            } else {
                System.out.println("调用失败，原因：" + response.getMsg() + "，" + response.getSubMsg());
            }
        } catch (Exception e) {
            System.out.println("调用遭遇异常，原因：" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @ResponseBody
    @GetMapping("/web")
    public String web() {
        try {
            // 1. 创建AlipayClient实例
            AlipayClient alipayClient = new DefaultAlipayClient(getClientParams());
            // 2. 创建使用的Open API对应的Request请求对象
            AlipayTradePagePayRequest request = getRequestWeb();
            // 3. 发起请求并处理响应
            AlipayTradePagePayResponse response = alipayClient.pageExecute(request);
            if (response.isSuccess()) {
                System.out.println("调用成功。");
                return response.getBody();
            } else {
                System.out.println("调用失败，原因：" + response.getMsg() + "，" + response.getSubMsg());
            }
        } catch (Exception e) {
            System.out.println("调用遭遇异常，原因：" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @ResponseBody
    @GetMapping("/app")
    public String app() {
        try {
            // 1. 创建AlipayClient实例
            AlipayClient alipayClient = new DefaultAlipayClient(getClientParams());
            // 2. 创建使用的Open API对应的Request请求对象
            AlipayTradePagePayRequest request = getRequestWeb();
            // 3. 发起请求并处理响应
            AlipayTradePagePayResponse response = alipayClient.sdkExecute(request);
            if (response.isSuccess()) {
                System.out.println("调用成功。");
                return response.getBody();
            } else {
                System.out.println("调用失败，原因：" + response.getMsg() + "，" + response.getSubMsg());
            }
        } catch (Exception e) {
            System.out.println("调用遭遇异常，原因：" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    private static CertAlipayRequest getClientParams() {
        CertAlipayRequest certParams = new CertAlipayRequest();
        certParams.setServerUrl("https://openapi.alipay.com/gateway.do");
        //请更换为您的AppId
        certParams.setAppId("2021002106644714");
        //请更换为您的PKCS8格式的应用私钥
        certParams.setPrivateKey("MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC3rgHa/x67gaY08RJoeVWLghAiQooLG/dOojW+639RAuirhxLyeuawbcch291uj/90MPTQy86nNKKQBbet41MQtS8L6ts/5Bjp2GYgzsQlmPCRWE7Il94/6R18fg9ZZQ4rx280BrX60hKTFcM+rn6IuNAiT7wHMcsjonRLsbWW/ZaSmMwqJcfhRU2/8Slznw2AX8jHs3X/ZZtM8usm3Hd41U9m7DIRPgejo4wlgTmUrFJrgQIWdsuSCYm88a4BzFc3Wfa2No5stqkHZizsshx52UGOgvgJdxF6PUqC9af+qQSdldTcbOeQjgQbJOLfiZoPQzyO8DaszIzJkB8FB38DAgMBAAECggEBAIbZ7qzMjtCU3+SQdLZVFlQFGjk85sI/NvL5LkJL/T4Jx65eza9OQd2XyxH1rH1GpQK2CpbceozRnOPl/rNgaRSkILU8KNmgahYM9PXzN5huz3e2AKlOrjH3wNksZ7J2+c90bRUiNCrAXji0SpLTYzyXit8V8PLLQNuZoo4MG0iNCJy8riZwUn8ZQLJnCMv1VD0yUyGSr/6LAEJjJZTrrnpibw/99hqFO8Z6UvIs9JewfvjdzamT3UxF0gURSncieQwvsq3mYlq6ppcWqzBrEqJHZJOGzZrxtsOALmOFr7KCp6qRziareK/9vb9RLnZtBSrLZqhJF/MU1oFWpHixRoECgYEA3yKt0rT2v1rjaOlMQDF7pKKfnGmRHGps9214Smsj/wOwWdlwwixWZA2DUFLOUpPQRu3dPp3ZZQdcg21NejvEbtu4CcN0lrvnVlBIrExQmm9zqjDWijljtNvf+POqMkwyLumtNtdNxWLZxdiDClosShEX9kv4ttdlF5bEc2z3V8ECgYEA0rumR+zUnvT6OS6l6msUXgZ/f/XBgcW8BLdZV6pSJJVh3I9CVgc55MlTTGTd0yNfrDPVbwloDpjVVPSNI9YNL0h9i0vfMTHolWOR7RCcqBoquvt66NjtaV70PjBm1pxNVVDaUSgCva+oOFaRnoHjOSA+jyZkKRHjwnEWlcyRZ8MCgYBnZCtE6gM3cYbUEt35FLSk+ZGZqTTLBOlO0NOfL/vy6yOozl84KdEx9Sz2aBggHUuxwf/1RrD35ixQ3bG7xLvlXjvtkjqQqaqszPCPnaDvnlrq7kxKqgLwR72FHmqrebD7Gd3f/m2T25Tq3sMBZf0FqNwAjP1Gw5GdF4gZr9EAQQKBgQCQrWgxxTUMlOAd1hru3+kxzIBIl67sq5a0HjTmbPbMSwrO5EQE0B09J8NalX198bFDhqqn+utH6kG8e9FSoyiWJ8yZj9OB8OPffGa5PUhwWNaxXOo7ZoNIbnp9H7na6aBmTIY2ZaPMGwcA9t4u1rnrhGmu2gq176RQ4FdDLRk/BQKBgQDU+Oab3jL2MoDMtGk4ZGYQUcTMB/ILtG4O1bx8BhJZ/Rula3Rt7dYPrRng3uZ0sTVh7/QRSn02hLY72UoItge3POZMEbNQLb+gzhIuU4v4hLT3H6WK2MSaLftsb9mPyW9LX76xQS4ayf5xZqeKK2jOtIZCsiLmC/ALvIytcr2DHA==");
        //请更换为您使用的字符集编码，推荐采用utf-8
        certParams.setCharset("utf-8");
        certParams.setFormat("json");
        certParams.setSignType("RSA2");
        //请更换为您的应用公钥证书文件路径
        certParams.setCertPath("/Users/liulipeng/Web/lianghuapai/baa-pay/baa-pay-server/src/main/resources/alipay/appCertPublicKey_2021002106644714.crt");
        //请更换您的支付宝公钥证书文件路径
        certParams.setAlipayPublicCertPath("/Users/liulipeng/Web/lianghuapai/baa-pay/baa-pay-server/src/main/resources/alipay/alipayCertPublicKey_RSA2.crt");
        //更换为支付宝根证书文件路径
        certParams.setRootCertPath("/Users/liulipeng/Web/lianghuapai/baa-pay/baa-pay-server/src/main/resources/alipay/alipayRootCert.crt");
        return certParams;
    }

    private static AlipayTradeWapPayRequest getRequestH5() {
        // 初始化Request，并填充Model属性。实际调用时请替换为您想要使用的API对应的Request对象。
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(UUID.randomUUID().toString().replace("-", ""));
        model.setProductCode("QUICK_WAP_WAY");
        model.setTotalAmount("0.01");
        model.setSubject("这是订单标题");
        model.setBody("这是订单描述");
        request.setBizModel(model);
        request.setNotifyUrl("");
        request.setReturnUrl("");
        return request;
    }

    private static AlipayTradePagePayRequest getRequestWeb() {
        // 初始化Request，并填充Model属性。实际调用时请替换为您想要使用的API对应的Request对象。
        AlipayTradePagePayRequest request = new AlipayTradePagePayRequest();
        AlipayTradePagePayModel model = new AlipayTradePagePayModel();
        model.setOutTradeNo(UUID.randomUUID().toString().replace("-", ""));
        model.setProductCode("FAST_INSTANT_TRADE_PAY");
        model.setTotalAmount("0.01");
        model.setSubject("这是订单标题");
        model.setBody("这是订单描述");
        request.setBizModel(model);
        request.setNotifyUrl("");
        request.setReturnUrl("");
        return request;
    }

    private static AlipayTradeAppPayRequest getRequestApp() {
        // 初始化Request，并填充Model属性。实际调用时请替换为您想要使用的API对应的Request对象。
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setOutTradeNo(UUID.randomUUID().toString().replace("-", ""));
        model.setProductCode("QUICK_MSECURITY_PAY");
        model.setTotalAmount("0.01");
        model.setSubject("这是订单标题");
        model.setBody("这是订单描述");
        request.setBizModel(model);
        request.setNotifyUrl("");
        request.setReturnUrl("");
        return request;
    }

}
