package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.DictType;
import cn.quant.spring.data.jpa.entity.OptimisticEntity;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Entity
@Table(name = "dictionary")
public class DictionaryEntity extends OptimisticEntity implements Serializable {

    @EmbeddedId
    private DictionaryIds ids;

    @Column(name = "NAME", nullable = false, length = 255)
    private String name;

    @Column(name = "IMAGE_URL", nullable = true, length = 500)
    private String imageUrl;

    public DictionaryIds getIds() {
        return ids;
    }

    public void setIds(DictionaryIds ids) {
        this.ids = ids;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DictionaryEntity that = (DictionaryEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("DictionaryEntity{");
        sb.append("ids=").append(ids);
        sb.append(", name='").append(name).append('\'');
        sb.append(", imageUrl='").append(imageUrl).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    public String getType(){
        return ids.getType();
    }

    public String getCode(){
        return ids.getCode();
    }
}
