package cn.quant.baa.pay.config;

import cn.quant.baa.pay.jpa.entity.DictionaryEntity;
import cn.quant.baa.pay.jpa.repository.DictionaryRepository;
import cn.quant.baa.pay.model.dto.DictionaryItemDTO;
import cn.quant.spring.data.jpa.PersistentEntityInvoker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.support.Repositories;

import java.util.List;

/**
 * Created by Administrator on 2021/9/18 0018.
 */
@Configuration
public class ServerConfiguration {

    @Autowired
    private DictionaryRepository dictionaryRepository;

    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public DictionaryViewer dictionaryViewer() {
        DictionaryViewer dictionary = DictionaryViewer.getInstance();
        List<DictionaryEntity> entities = dictionaryRepository.findAll();
        for (DictionaryEntity entity : entities) {
            if (entity.getParentId().compareTo(0) > 0) {
                DictionaryItemDTO item = new DictionaryItemDTO();
                item.setCode(entity.getCode());
                item.setType(entity.getType());
                item.setText(entity.getText());
                item.setValue(entity.getValue());
                item.setImageUrl(entity.getImageUrl());
                dictionary.add(item);
            }
        }
        return dictionary;
    }

    @Bean
    public PersistentEntityInvoker persistentEntityInvoker() {
        Repositories repositories = new Repositories(applicationContext);
        PersistentEntityInvoker invoker = new PersistentEntityInvoker(repositories);
        return invoker;
    }
}

