package cn.quant.baa.pay;

import cn.quant.spring.util.IdentitySequencer;
import cn.quant.spring.util.ServerUtils;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p><b>Application VM Option:</b><br/>
 * <code>--spring.config.file=${project.build.directory}/target/config/application-dev.properties </code><br/>
 * <code>-Dlogging.config=${project.build.directory}/target/config/logback-spring.xml</code></p>
 * <p><b>Enable Dubbo Annotation: </b><br/>
 * <code>@org.springframework.context.annotation.ImportResource(locations = {"classpath:application-dubbo.xml"})</code></p>
 */
@EnableApolloConfig
@ComponentScan
@SpringBootApplication
@EnableAutoConfiguration
@PropertySource(value = {"classpath:config/bootstrap.yml"
        , "classpath:config/application.yml"})
public class ServerApplication {

    @Inject
    private ApplicationContext context;

    @PostConstruct
    private void init() throws Exception {
        Environment environment = context.getEnvironment();
        IdentitySequencer sequencer = context.getBean(IdentitySequencer.class);
        Logger logger = LoggerFactory.getLogger(ServerApplication.class);
        logger.info("\n---------------------------------------------------------------------\n" +
                        "\tWorker Id : {}\n" +
                        "\tServer IP : {}\n" +
                        "\tConfig File : {}\n" +
                        "\tSpring Profiles : {}\n" +
                        "\tRuntime : {}\n" +
                        "\n---------------------------------------------------------------------\n"
                , sequencer.workerId()
                , ServerUtils.getHostAddress()
                , environment.getProperty("spring.config.file")
                , environment.getActiveProfiles()
                , LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(ServerApplication.class);
        ConfigurableApplicationContext context = application.run(args);
    }
}