package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.model.web.MerchantAcquirerProperties;
import cn.quant.baa.pay.model.web.MerchantChannelResponseData;
import cn.quant.baa.pay.model.web.MerchantChannelRequestData;
import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.util.AssertUtils;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.service.MerchantService;
import cn.quant.spring.http.HttpResponseData;
import cn.quant.spring.rest.AbstractController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

import static cn.quant.baa.pay.dict.MessageEnum.*;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@RestController
@RequestMapping("/merchant/channel")
public class MerchantController extends AbstractController {

    @Autowired
    private MerchantService merchantService;

    @Autowired
    private CacheManager cacheManager;

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/list")
    public ResponseEntity list(@RequestBody BusinessRequest<MerchantChannelRequestData> request) {
        TransactionSession session = TransactionSession.session();
        String requestId = session.getRequestId();

        MerchantChannelRequestData data = request.getData();
        if (data == null) {
            AssertUtils.throwMessage(EMPTY_REQ_DATA);
        }


        Map<String, MerchantChannelResponseData> channels = merchantService.getChannels(data);
        ResponseEntity<HttpResponseData> entity = succeed(session.getRequestId(), channels);
        return entity;
    }

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/one")
    public ResponseEntity one(@RequestBody BusinessRequest<MerchantChannelRequestData> request) {
        TransactionSession session = TransactionSession.session();
        String requestId = session.getRequestId();

        MerchantChannelRequestData data = request.getData();
        if (data == null) {
            AssertUtils.throwMessage(EMPTY_REQ_DATA);
        }


        MerchantAcquirerProperties channel = merchantService.getChannel(data);
        ResponseEntity<HttpResponseData> entity = succeed(session.getRequestId(), channel);
        return entity;
    }
}
