package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.acquirer.AcquirerProperties;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.dict.*;
import cn.quant.baa.pay.model.web.GoodsDetail;
import cn.quant.baa.pay.model.web.PayRequestData;
import cn.quant.spring.util.DateUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

import static cn.quant.baa.pay.Constant.MINI_LOCAL_DATE;

/**
 * Created by Administrator on 2021/8/27 0027.
 */
public class EntityBuilder {

    private static int nextTxnNo(AccountEntity account) {
        Integer txnNo = account.getNextTxnNo();
        account.setTxnNo(txnNo);
        account.setNextTxnNo(txnNo + 1);
        return txnNo;
    }

    public static AccountEntity account(AccountIds ids, String productId, long accountId, String buyerId, int partitionKey) {
        LocalDate now = LocalDate.now();
        AccountEntity account = new AccountEntity();
        account.setIds(ids);
        account.setAccountId(accountId);
        account.setAcctTypeId(AcctTypeId.EMPS);
        account.setAutoPaymentFlag(false);
        account.setAutoPaymentWarnDate(MINI_LOCAL_DATE);
        account.setAutoStatus(StatusCode.NORM);
        account.setAutoStatusDate(now);
        account.setCorpotateAcctFlag(false);
        account.setCreditTxnCount(0);
        account.setCurrencyCode(CurrencyCode.CNY);
        account.setCurrentCycleNo(1);
        account.setDebitTxtCount(0);
        account.setExternalAcctNo(buyerId);
        account.setManualStatus(null);
        account.setManualStatusDate(null);
        account.setNextTxnNo(1);
        account.setOpenDate(now);
        account.setProductId(productId);
        account.setProtocolRule(null);
        account.setTotalCredit(BigDecimal.ZERO);
        account.setTotalDebit(BigDecimal.ZERO);
        account.setTxnNo(0);

        Date date = DateUtils.now();
        account.setCreatedDate(date);
        account.setModifiedDate(date);
        account.setPartitionKey(partitionKey);
        return account;
    }

    public static PayHistoryEntity history(AccountEntity account, PayHistoryIds ids, long historyId, PayRequestData data, AcquirerProperties profile
            , TransactionSession session) {

        BigDecimal discount = new BigDecimal(data.getDiscounts());
        BigDecimal origAmt = new BigDecimal(data.getOriginalAmount());
        BigDecimal cash = new BigDecimal(data.getCashAmount());
        BigDecimal credit = new BigDecimal(data.getCreditAmount());
        BigDecimal amount = new BigDecimal(data.getAmount());
        String signer = data.getGoodsSigner();

        Long accountId = account.getAccountId();

        PayHistoryEntity entity = new PayHistoryEntity();
        entity.setIds(ids);
        entity.setAccountId(accountId);
        entity.setAddress(data.getAddress());
        entity.setAttachText(data.getAttach());
        entity.setCreditDebitFlag(CreditDebitFlag.C);
        entity.setCurrencyCode(CurrencyCode.CNY);
        entity.setCustomerGenFlag(true);
        entity.setDiscAmount(discount);
        entity.setGenFeeAmount(BigDecimal.ZERO);
        entity.setGoodsSigner(signer);
        entity.setShopName(data.getShopName());
        entity.setMobilePhone(data.getPhoneNo());
        entity.setNotifyUrl(data.getNotifyUrl());
        entity.setOriginalTxnAmount(origAmt);
        entity.setPayDueTime(LocalDateTime.now().plusMinutes(30));
        entity.setPayAcctId(profile.getPayAcctId());
        entity.setPayChanCode(profile.getPayChanCode());
        entity.setPayAppId(profile.getPayAppId());
        entity.setPayMethod(PayMethod.DRST);
        entity.setPostCashAmount(cash);
        entity.setPostCreditAmount(credit);
        entity.setPartitionKey(account.getPartitionKey());
        entity.setRequestId(session.getRequestId());
        entity.setRequestTime(session.getRequestTime());
        entity.setShopName(data.getShopName());
        entity.setStatementeFlag(true);
        entity.setStatisticsCode("RPAY");
        entity.setStatusCode(StatusCode.PEND);
        entity.setSubject(data.getSubject());
        entity.setTransactionId(historyId);
        entity.setTxnAmount(amount);
        entity.setTxnDate(session.getBusinessLocalDate());
        entity.setTxnTime(session.getBusinessLocalTime());
        entity.setTxnType("RETL");
        entity.setTxnNo(nextTxnNo(account));
        if (cash.compareTo(BigDecimal.ZERO) > 0) {
            entity.setTxnCode("R001");
        } else {
            entity.setTxnCode("R002");
        }
        if (cash.add(credit).compareTo(cash.max(credit)) > 0) {
            entity.setTxnCode("R003");
        }
        return entity;
    }

    public static PayGoodsDetailEntity goodsDetail(long goodsId, long historyId, GoodsDetail detail) {
        BigDecimal amount = new BigDecimal(detail.getAmount());
        BigDecimal discount = new BigDecimal(detail.getDiscounts());
        BigDecimal price = new BigDecimal(detail.getPrice());
        int qiantity = Integer.parseInt(detail.getQuantity(), 10);

        PayGoodsDetailEntity entity = new PayGoodsDetailEntity();
        entity.setAttachText(detail.getAttach());
        entity.setDiscAmount(discount);
        entity.setTxnAmount(amount);
        entity.setTransactionId(historyId);
        entity.setGoodsId(goodsId);
        entity.setGoodsName(detail.getGoodsName());
        entity.setGoodsOrderNo(detail.getGoodsNo());
        entity.setPrice(price);
        entity.setQuantity(qiantity);

        return entity;
    }

}
