package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.OptimisticEntity;
import cn.quant.spring.util.StringUtils;
import org.hibernate.annotations.Type;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Entity
@Table(name = "pay_app")
public class PayAppEntity extends OptimisticEntity implements Serializable {

    private static final long serialVersionUID = -5502377854231068271L;

    private final static String CLASS_NAME = PayAppEntity.class.getSimpleName();

    @Id
    @Column(name = "PAY_APP_ID", nullable = false, updatable = false, length = 32)
    private String payAppId;

    @Column(name = "INSTITUTION_ID", nullable = false, updatable = false, length = 4)
    private String institutionId;

    @Column(name = "PRODUCT_ID", nullable = false, updatable = false, length = 4)
    private String productId;

    @Column(name = "PAY_APP_NAME", nullable = false, length = 255)
    private String payAppName;

    @Column(name = "SECURITY_KEY", nullable = false, length = 64)
    private String securityKey;

    @Column(name = "START_DATE", nullable = false)
    private LocalDate startDate;

    @Column(name = "END_DATE", nullable = false)
    private LocalDate endDate;

    @Type(type = "yes_no")
    @Column(name = "ACTIVATED_FLAG", nullable = false, length = 1)
    private Boolean activatedFlag;

    public String getPayAppId() {
        return payAppId;
    }

    public void setPayAppId(String payAppId) {
        this.payAppId = payAppId;
    }

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getPayAppName() {
        return payAppName;
    }

    public void setPayAppName(String payAppName) {
        this.payAppName = payAppName;
    }

    public String getSecurityKey() {
        return securityKey;
    }

    public void setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Boolean getActivatedFlag() {
        return activatedFlag;
    }

    public void setActivatedFlag(Boolean activatedFlag) {
        this.activatedFlag = activatedFlag;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, payAppId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PayAppEntity)) return false;
        PayAppEntity that = (PayAppEntity) o;
        return Objects.equals(payAppId, that.payAppId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayAppEntity{");
        sb.append("payAppId='").append(payAppId).append('\'');
        sb.append(", payAppName='").append(payAppName).append('\'');
        sb.append(", securityKey='").append(securityKey).append('\'');
        sb.append(", startDate=").append(startDate);
        sb.append(", endDate=").append(endDate);
        sb.append(", activatedFlag=").append(activatedFlag);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
