package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.jpa.entity.PayHistoryEntity;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.model.web.PayRequestData;
import cn.quant.baa.pay.service.TransactionService;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.web.bind.annotation.*;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@RestController
@RequestMapping("/transaction")
public class TransactionController extends BusinessController {

    @Autowired
    private TransactionService transactionService;

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/pay")
    public void pay(@RequestBody BusinessRequest<PayRequestData> request) {

        PayRequestData data = request.getData();
        PayHistoryEntity pay = transactionService.pay(data);

        System.currentTimeMillis();
    }
}
