package cn.quant.baa.pay.acquirer;

import cn.quant.spring.security.Base64Cipher;
import cn.quant.spring.security.CharacterCipher;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

/**
 * Created by Administrator on 2021/8/31 0031.
 */
public abstract class MerchantAcquirer {

    protected CharacterCipher characterCipher;

    protected Cipher cipher;

    protected SecretKeySpec secretKey;

    public MerchantAcquirer init(AcquirerProperties properties) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {

        characterCipher = new Base64Cipher();

        String secretType = properties.getSecretType();
        if (secretType.startsWith("AES")) {
            secretKey = new SecretKeySpec(properties.getSecretKey().getBytes(), "AES");
        }
        cipher = Cipher.getInstance(secretType);
        cipher.init(Cipher.ENCRYPT_MODE, secretKey);

        Base64.getEncoder().encodeToString("aaa".getBytes());

//        byte[] raw = sKey.getBytes("utf-8");
//        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
//        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");//"算法/模式/补码方式"
//        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
//        byte[] encrypted = cipher.doFinal(sSrc.getBytes("utf-8"));
//        return new BASE64Encoder().encode(encrypted);//此处使用BASE64做转码功能，同时能起到2次加密的作用。

        return this;
    }
}
