package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.PayChanType;
import cn.quant.spring.data.jpa.entity.OptimisticEntity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Entity
@Table(name = "pay_account")
public class PayAccountEntity extends OptimisticEntity implements Serializable {

    private static final long serialVersionUID = 272268892694382599L;

    @EmbeddedId
    private PayAccountIds ids;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "PAY_CHAN_TYPE", nullable = false, length = 4)
    private PayChanType payChanType;

    @Column(name = "DOMAIN", nullable = false, length = 255)
    private String domain;

    @Column(name = "NAME", nullable = false, length = 255)
    private String name;

    @Column(name = "SECRET_KEY", nullable = false, length = 64)
    private String secretKey;

    @Column(name = "SECRET_TYPE", nullable = false, length = 32)
    private String secretType;

    @Column(name = "SIGN_TYPE", nullable = false, length = 32)
    private String signType;

    @Column(name = "PRIVATE_KEY", nullable = false, length = 255)
    private String privateKey;

    @Column(name = "PAY_PUBLIC_KEY", nullable = false, length = 255)
    private String payPublicKey;

    @Column(name = "PAY_CERT_NO", nullable = true, length = 64)
    private String payCertNo;

    @Column(name = "PAY_CERT_KEY", nullable = true, length = 2000)
    private String payCertKey;

    @Column(name = "PAY_ROOT_CERT_NO", nullable = true, length = 64)
    private String payRootCertNo;

    @Column(name = "PAY_ROOT_CERT_KEY", nullable = true, length = 4000)
    private String payRootCertKey;

    public PayAccountIds getIds() {
        return ids;
    }

    public void setIds(PayAccountIds ids) {
        this.ids = ids;
    }

    public PayChanType getPayChanType() {
        return payChanType;
    }

    public void setPayChanType(PayChanType payChanType) {
        this.payChanType = payChanType;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String encryptKey) {
        this.secretKey = encryptKey;
    }

    public String getSecretType() {
        return secretType;
    }

    public void setSecretType(String encryptType) {
        this.secretType = encryptType;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPayPublicKey() {
        return payPublicKey;
    }

    public void setPayPublicKey(String payPublicKey) {
        this.payPublicKey = payPublicKey;
    }

    public String getPayCertNo() {
        return payCertNo;
    }

    public void setPayCertNo(String payCertNo) {
        this.payCertNo = payCertNo;
    }

    public String getPayCertKey() {
        return payCertKey;
    }

    public void setPayCertKey(String payCertKey) {
        this.payCertKey = payCertKey;
    }

    public String getPayRootCertNo() {
        return payRootCertNo;
    }

    public void setPayRootCertNo(String payRootCertNo) {
        this.payRootCertNo = payRootCertNo;
    }

    public String getPayRootCertKey() {
        return payRootCertKey;
    }

    public void setPayRootCertKey(String payRootCertKey) {
        this.payRootCertKey = payRootCertKey;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PayAccountEntity)) return false;
        PayAccountEntity that = (PayAccountEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayAccountEntity{");
        sb.append("ids=").append(ids);
        sb.append(", payChanType=").append(payChanType);
        sb.append(", domain='").append(domain).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", secretType='").append(secretType).append('\'');
        sb.append(", signType='").append(signType).append('\'');
        sb.append(", payCertNo='").append(payCertNo).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }

}
