package cn.quant.baa.pay.acquirer;

import cn.quant.spring.security.Base64Cipher;
import cn.quant.spring.security.CharacterCipher;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * Created by Administrator on 2021/8/31 0031.
 */
public abstract class MerchantAcquirer {

    protected Cipher cipher;

    protected SecretKeySpec secretKey;

    protected CharacterCipher secretCipher;

    public MerchantAcquirer init(AcquirerProperties properties) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {

        this.secretCipher = new Base64Cipher();
        String secretType = properties.getSecretType();
        if (secretType.startsWith("AES")) {
            this.secretKey = new SecretKeySpec(properties.getSecretKey().getBytes(), "AES");
        }
        this.cipher = Cipher.getInstance(secretType);
        this.cipher.init(Cipher.ENCRYPT_MODE, this.secretKey);

        //

        return this;
    }
}
