package cn.quant.baa.pay.model.web;

import cn.quant.spring.data.jpa.PersistentKey;
import cn.quant.spring.util.StringUtils;

import java.io.Serializable;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
public class MerchantChannelRequestData implements PersistentKey, Serializable {
    private static final long serialVersionUID = 5193795607930304626L;

    private String chanId;

    private String mchId;

    private String channel;

    private String access;

    public String getChanId() {
        return chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getAccess() {
        return access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getPersistentKey() {
        return StringUtils.toDelimitedString(mchId, channel, access);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("MerchantChannelRequestData{");
        sb.append("chanId=").append(chanId);
        sb.append(", mchId='").append(mchId).append('\'');
        sb.append(", channel='").append(channel).append('\'');
        sb.append(", access='").append(access).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
