package cn.quant.baa.pay.service;

import cn.quant.baa.pay.config.MerchantAcquirerBuilder;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.jpa.entity.AccountEntity;
import cn.quant.baa.pay.jpa.entity.EntityBuilder;
import cn.quant.baa.pay.jpa.entity.PayHistoryEntity;
import cn.quant.baa.pay.jpa.entity.PayHistoryIds;
import cn.quant.baa.pay.model.AssertUtils;
import cn.quant.baa.pay.model.GoodsDetail;
import cn.quant.baa.pay.model.MerchantAcquirerProfile;
import cn.quant.baa.pay.model.PayRequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import static cn.quant.baa.pay.dict.MessageEnum.*;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@Service
public class TransactionService extends BusinessService {

    private static final Logger logger = LoggerFactory.getLogger(TransactionService.class);

    @Autowired
    private MerchantAcquirerBuilder merchantAcquirerBuilder;

    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public void check(PayHistoryIds ids, TransactionSession session) {
        PayHistoryEntity historyEntity = session.findOne(PayHistoryEntity.class, ids);
        if (historyEntity != null) {
            AssertUtils.throwMessage(EXIST_ORDER, ids.getInstitutionId(), ids.getProductId(), ids.getExternalOrderNo());
        }
    }

    @Transactional
    public void pay(PayRequestData data) {

        validate(data);

        String chanId = data.getChanId();
        MerchantAcquirerProfile profile = merchantAcquirerBuilder.get(Long.valueOf(chanId));
        if (profile == null) {
            AssertUtils.throwMessage(ACQUIRER_NOSUCH, chanId);
        }

        String mchId = data.getMchId();
        if (!mchId.equals(profile.getPayAppId())) {
            AssertUtils.throwMessage(ACQUIRER_NOMATCH, chanId, mchId);
        }

        String institutionId = profile.getInstitutionId();
        String productId = profile.getProductId();
        TransactionSession session = TransactionSession.session();


        String outTradeNo = data.getOutTradeNo();
        PayHistoryIds ids = new PayHistoryIds();
        ids.setInstitutionId(institutionId);
        ids.setProductId(productId);
        ids.setExternalOrderNo(outTradeNo);
        check(ids, session);

        GoodsDetail[] goodsDetail = data.getGoodsDetail();





        String buyerId = data.getBuyerId();
        prepare(institutionId, productId, buyerId, session);
        AccountEntity account = session.getAccount();


        PayHistoryEntity history = EntityBuilder.history(profile, account, ids, data, session);
        session.pushEntity(history);

        session.commit();

    }
}
