package cn.quant.baa.pay.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
public class MerchantAcquirerBook implements Serializable {
    private static final long serialVersionUID = -7479646457077040392L;

    private String code;

    private String name;

    private String imageUrl;

    private Map<String, MerchantAcquirer> acquirers;

    public MerchantAcquirerBook() {
        acquirers = new HashMap<String, MerchantAcquirer>();
    }

    public Map<String, MerchantAcquirer> getAcquirers() {
        return acquirers;
    }

    public void add(MerchantAcquirer acquirer) {
        acquirers.put(acquirer.getAccessCode(), acquirer);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("MerchantAcquirerBook{");
        sb.append("code='").append(code).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", imageUrl='").append(imageUrl).append('\'');
        sb.append(", acquirers=").append(acquirers);
        sb.append('}');
        return sb.toString();
    }
}
