/*
Navicat MySQL Data Transfer

Source Server         : pay-dev
Source Server Version : 50643
Source Host           : 172.17.6.12:30406
Source Database       : baa_pay_1.0

Target Server Type    : MYSQL
Target Server Version : 50643
File Encoding         : 65001

Date: 2021-09-29 10:55:50
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for account
-- ----------------------------
DROP TABLE IF EXISTS `account`;
CREATE TABLE `account` (
  `ACCOUNT_ID` bigint(19) NOT NULL COMMENT '账户ID',
  `INSTITUTION_ID` char(4) NOT NULL COMMENT '机构ID',
  `PRODUCT_ID` char(4) NOT NULL COMMENT '产品ID',
  `PROTOCOL_RULE` char(4) DEFAULT NULL COMMENT '方案规则',
  `ACCT_TYPE_ID` char(4) NOT NULL COMMENT '账户类型',
  `CURRENT_CYCLE_NO` smallint(4) NOT NULL COMMENT '当前周期号',
  `CURRENCY_CODE` char(3) NOT NULL COMMENT '币种',
  `MANUAL_STATUS` char(4) DEFAULT NULL COMMENT '手动状态码',
  `MANUAL_STATUS_DATE` int(8) DEFAULT NULL COMMENT '手动状态设置时间',
  `AUTO_STATUS` char(4) NOT NULL COMMENT '自动状态码',
  `AUTO_STATUS_DATE` int(8) NOT NULL COMMENT '自动状态设置时间',
  `OPEN_DATE` int(8) NOT NULL COMMENT '开户日期',
  `CORPOTATE_ACCT_FLAG` char(1) NOT NULL COMMENT '公司账户标志(Y/N)',
  `ACCOUNT_REF_NO` char(32) NOT NULL COMMENT '账户参考号(无特殊使用ACCOUNT_ID)',
  `EXTERNAL_ACCT_NO` varchar(32) DEFAULT NULL COMMENT '外部系统账户号',
  `AUTO_PAYMENT_FLAG` char(1) NOT NULL COMMENT '自动还款标志(Y/N)',
  `AUTO_PAYMENT_WARN_DATE` int(8) NOT NULL COMMENT '自动还款提示日期(19700101:默认)',
  `TXN_NO` int(11) NOT NULL COMMENT '交易号',
  `NEXT_TXN_NO` int(8) NOT NULL COMMENT '下一个交易号',
  `TOTAL_CREDIT` decimal(17,2) NOT NULL DEFAULT '0.00' COMMENT '贷记总计金额(0:默认)',
  `TOTAL_DEBIT` decimal(17,2) NOT NULL DEFAULT '0.00' COMMENT '借记总计金额(0:默认)',
  `CREDIT_TXN_COUNT` int(9) NOT NULL DEFAULT '0' COMMENT '贷记交易笔数(0:默认值)',
  `DEBIT_TXT_COUNT` int(9) NOT NULL DEFAULT '0' COMMENT '借记交易笔数(0:默认值)',
  `DESC_TEXT` varchar(400) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(72) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(72) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `PARTITION_KEY` smallint(4) NOT NULL COMMENT '分区键',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`ACCOUNT_ID`),
  UNIQUE KEY `UK_IDS` (`INSTITUTION_ID`,`ACCOUNT_REF_NO`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='账户\r\n\r\nSTATEMENT_FREQ_NO：指定n个周期出账单。STATEMENT_FREQ为''NCYC''，该项必须有值，否则为0。\r\nLAST_DLQ_DAYS：不包括当期，从LAST_DLQ_DATE开始算起。\r\nFIXED_PAYMENT_AMOUNT：如果FIXED_PAYMENT_UNTIL_DATE 大于今天，Min Payment.MIN_PAY_CALC_METHOD为''FMIN''，使用FIXED_PAYMENT_AMOUNT代替最小还款金额。\r\nMULTIPLE_ACCOUNTS_FLG：如果Min Payment.MIN_PAY_CALC_METHOD为''%-HI''，取此值为余额计算基数。如果此值为''N''只同步当前账户最高余额。';

-- ----------------------------
-- Records of account
-- ----------------------------
INSERT INTO `account` VALUES ('75956717762838633', 'YXM', 'LDW', null, 'EMPS', '1', 'CNY', null, null, 'NORM', '20210923', '20210923', 'N', '777777', '777777', 'N', '19700101', '4', '5', '0.00', '0.00', '0', '0', null, 'SYS', '2021-09-23 10:32:15', 'SYS', '2021-09-23 11:55:02', '4', '105', null, null, null);
INSERT INTO `account` VALUES ('75958421027815495', 'YXM', 'LDW', null, 'EMPS', '1', 'CNY', null, null, 'NORM', '20210923', '20210923', 'N', '000008', '000008', 'N', '19700101', '20', '21', '0.00', '0.00', '0', '0', null, 'SYS', '2021-09-23 17:45:34', 'SYS', '2021-09-28 19:35:51', '20', '71', null, null, null);

-- ----------------------------
-- Table structure for batch_cycle_trigger
-- ----------------------------
DROP TABLE IF EXISTS `batch_cycle_trigger`;
CREATE TABLE `batch_cycle_trigger` (
  `TRIGGER_ID` bigint(19) NOT NULL,
  `TARGET_ID` bigint(19) NOT NULL,
  `ENTITY_CODE` char(4) NOT NULL,
  `ACCOUNT_ID` bigint(19) NOT NULL,
  `PAY_DUE_TIME` bigint(14) NOT NULL,
  `NOTIFY_URL` varchar(1000) NOT NULL,
  `CHAN_NOTIFY_STATUS` char(4) NOT NULL,
  `CHAN_NOTIFY_TIME` datetime DEFAULT NULL,
  `MCH_NOTIFY_STATUS` char(4) NOT NULL,
  `MCH_NOTIFY_TIME` datetime DEFAULT NULL,
  `REQUEST_ID` char(64) DEFAULT NULL,
  `PARTITION_KEY` smallint(4) NOT NULL COMMENT '分区键',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`TRIGGER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of batch_cycle_trigger
-- ----------------------------
INSERT INTO `batch_cycle_trigger` VALUES ('75774627221405700', '75774627146563586', 'PYMT', '75958421027815495', '20210928170450', 'http://127.0.0.1:8080/notifyUrl', 'PEND', null, 'PEND', null, '20210928596882449073726264168', '71', 'SYS', '2021-09-28 16:34:50', 'SYS', '2021-09-28 16:34:50', '1', null, null, null);
INSERT INTO `batch_cycle_trigger` VALUES ('75775134562648068', '75775132633989122', 'PYMT', '75958421027815495', '20210928191351', 'http://127.0.0.1:8080/notifyUrl', 'PEND', null, 'PEND', null, '20210928674021420837199520672', '71', 'SYS', '2021-09-28 18:43:52', 'SYS', '2021-09-28 18:43:52', '1', null, null, null);
INSERT INTO `batch_cycle_trigger` VALUES ('75797980954296582', '75797980930965508', 'PYMT', '75958421027815495', '20210928200539', 'http://127.0.0.1:8080/notifyUrl', 'PEND', null, 'PEND', null, '2021092870538533845340021471', '71', 'SYS', '2021-09-28 19:35:40', 'SYS', '2021-09-28 19:35:40', '1', null, null, null);
INSERT INTO `batch_cycle_trigger` VALUES ('75797981754229257', '75797981730111751', 'PYMT', '75958421027815495', '20210928200551', 'http://127.0.0.1:8080/notifyUrl', 'PEND', null, 'PEND', null, '2021092870551768092563101044', '71', 'SYS', '2021-09-28 19:35:51', 'SYS', '2021-09-28 19:35:51', '1', null, null, null);

-- ----------------------------
-- Table structure for dictionary
-- ----------------------------
DROP TABLE IF EXISTS `dictionary`;
CREATE TABLE `dictionary` (
  `ID` bigint(20) NOT NULL,
  `TYPE` varchar(32) NOT NULL,
  `CODE` varchar(32) NOT NULL,
  `TEXT` varchar(64) NOT NULL,
  `VALUE` varchar(500) NOT NULL,
  `PARENT_ID` int(255) NOT NULL,
  `IMAGE_URL` varchar(500) DEFAULT NULL,
  `CREATED_BY` varchar(32) NOT NULL DEFAULT 'SYS' COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL DEFAULT 'SYS' COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of dictionary
-- ----------------------------
INSERT INTO `dictionary` VALUES ('100', 'PAY', 'ROOT', '支付通道商', '', '0', null, 'SYS', '2021-09-23 10:59:48', 'SYS', '2021-09-27 11:03:05', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('101', 'PAY', 'ALIP', '支付宝', '', '1', null, 'SYS', '2021-08-23 19:34:54', 'SYS', '2021-09-27 11:03:07', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('102', 'PAY', 'WXP', '微信', '', '1', null, 'SYS', '2021-08-23 19:33:58', 'SYS', '2021-09-27 11:03:13', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('200', 'HTTP_STAT', 'ROOT', '状态码', '0', '0', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:47', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('201', 'HTTP_STAT', 'SUCCESS', '成功', '200', '200', '', 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:50', '0', '', '', '');
INSERT INTO `dictionary` VALUES ('202', 'HTTP_STAT', 'APPID_MCHID_NOT_MATCH', '商户号与appid不匹配', '500500101', '200', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:23', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('203', 'HTTP_STAT', 'BANK_ERROR', '银行系统异常', '500500102', '200', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:19', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('204', 'HTTP_STAT', 'REFUND_LOGIC_ERROR', '退款业务流程错误', '500500103', '200', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:16', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('205', 'HTTP_STAT', 'ORDER_NO_EXISTS', '商户订单号重复', '500500104', '200', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:15', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('206', 'HTTP_STAT', 'PARAM_ERROR', '参数错误', '500500105', '200', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:14', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('207', 'HTTP_STAT', 'REQUEST_BLOCKED', '请求受阻', '500500106', '200', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:10:11', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('300', 'WXP_HTTP_STAT', 'ROOT', '状态码', 'ROOT', '0', null, 'SYS', '2021-09-23 10:58:49', 'SYS', '2021-09-28 19:21:26', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('302', 'WXP_HTTP_STAT', 'APPID_MCHID_NOT_MATCH', '商户号与appid不匹配', 'APPID_MCHID_NOT_MATCH', '300', null, 'SYS', '2021-09-23 11:03:48', 'SYS', '2021-09-28 19:21:28', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('303', 'WXP_HTTP_STAT', 'BANK_ERROR', '银行系统异常', 'BANK_ERROR', '300', null, 'SYS', '2021-09-23 11:06:49', 'SYS', '2021-09-28 19:21:28', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('304', 'WXP_HTTP_STAT', 'BIZ_ERR_NEED_RETRY', '退款业务流程错误', 'REFUND_LOGIC_ERROR', '300', null, 'SYS', '2021-09-23 11:06:49', 'SYS', '2021-09-28 19:21:29', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('305', 'WXP_HTTP_STAT', 'OUT_TRADE_NO_USED', '商户订单号重复', 'ORDER_NO_EXISTS', '300', null, 'SYS', '2021-09-23 14:06:13', 'SYS', '2021-09-28 19:21:30', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('306', 'WXP_HTTP_STAT', 'PARAM_ERROR', '参数错误', 'PARAM_ERROR', '300', null, 'SYS', '2021-09-23 11:06:49', 'SYS', '2021-09-28 19:21:31', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('307', 'WXP_HTTP_STAT', 'REQUEST_BLOCKED', '请求受阻', 'REQUEST_BLOCKED', '300', null, 'SYS', '2021-09-23 11:06:49', 'SYS', '2021-09-28 19:21:33', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('351', 'WXP_TXN_STAT', 'SUCCESS', '成功', 'SUCC', '300', '', 'SYS', '2021-09-23 11:03:48', 'SYS', '2021-09-28 19:21:44', '0', '', '', '');
INSERT INTO `dictionary` VALUES ('10000', 'WXP_CALLBACK_URL', 'ROOT', '应用配置', '', '0', null, 'SYS', '2021-09-23 11:06:49', 'SYS', '2021-09-28 15:06:35', '0', null, null, null);
INSERT INTO `dictionary` VALUES ('10001', 'WXP_CALLBACK_URL', 'H5', '通知地址', 'http://127.0.0.1:8090/transaction/pay/callback/wx', '10001', null, 'SYS', '2021-09-23 11:06:49', 'SYS', '2021-09-28 18:39:16', '0', null, null, null);

-- ----------------------------
-- Table structure for mch_channel
-- ----------------------------
DROP TABLE IF EXISTS `mch_channel`;
CREATE TABLE `mch_channel` (
  `ID` bigint(19) NOT NULL COMMENT '唯一标识',
  `PAY_APP_ID` char(32) NOT NULL COMMENT '支付应用ID',
  `PAY_CHAN_CODE` char(4) NOT NULL COMMENT '支付平台码',
  `ACCESS_CODE` varchar(6) NOT NULL COMMENT '接入方法码',
  `PAY_ACCT_ID` char(64) NOT NULL COMMENT '支付平台账户ID',
  `DESC_TEXT` varchar(255) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UK_IDS` (`PAY_APP_ID`,`PAY_CHAN_CODE`,`ACCESS_CODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商户通道';

-- ----------------------------
-- Records of mch_channel
-- ----------------------------
INSERT INTO `mch_channel` VALUES ('75772285618946308', 'wx75d5a207551d0b4d', 'WXP', 'APP', '1604055791', '小程序-狼大呜-APP', 'SYS', '2021-09-24 19:10:01', 'SYS', '2021-09-24 19:10:06', '0', null, null, null);
INSERT INTO `mch_channel` VALUES ('75772285618946309', 'wx2f44c7fe7b08458d', 'WXP', 'H5', '1604055791', '小程序-狼大呜-H5', 'SYS', '2021-09-24 19:10:01', 'SYS', '2021-09-24 19:10:06', '0', '', '', '');

-- ----------------------------
-- Table structure for pay_account
-- ----------------------------
DROP TABLE IF EXISTS `pay_account`;
CREATE TABLE `pay_account` (
  `PAY_CHAN_CODE` char(4) NOT NULL COMMENT '支付平台码',
  `PAY_ACCT_ID` char(64) NOT NULL COMMENT '支付平台账户ID',
  `PAY_CHAN_TYPE` char(4) NOT NULL COMMENT '支付平台类型',
  `DOMAIN` varchar(255) NOT NULL COMMENT '支付平台域',
  `NAME` varchar(255) NOT NULL COMMENT '账户名称',
  `SECRET_KEY` char(64) NOT NULL COMMENT '加密秘钥',
  `SECRET_TYPE` varchar(32) NOT NULL COMMENT '加密秘钥类型',
  `SIGN_TYPE` varchar(32) NOT NULL,
  `PRIVATE_KEY` varchar(2000) NOT NULL COMMENT '私钥',
  `PAY_PUBLIC_KEY` varchar(2000) NOT NULL COMMENT '支付平台私钥',
  `PAY_CERT_NO` char(65) DEFAULT NULL,
  `PAY_CERT_KEY` text,
  `PAY_ROOT_CERT_NO` char(65) DEFAULT NULL,
  `PAY_ROOT_CERT_KEY` text,
  `CREATED_BY` varchar(32) NOT NULL DEFAULT '' COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL DEFAULT '' COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PAY_CHAN_CODE`,`PAY_ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='支付账户';

-- ----------------------------
-- Records of pay_account
-- ----------------------------
INSERT INTO `pay_account` VALUES ('ALIP', '2021002106644714', 'THRD', 'https://openapi.alipay.com', '支付宝', '2X0QoyhfCb1iqLQszkfHoQ==', 'AES/CBC/PKCS5Padding', 'SHA256WithRSA', 'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC3rgHa/x67gaY08RJoeVWLghAiQooLG/dOojW+639RAuirhxLyeuawbcch291uj/90MPTQy86nNKKQBbet41MQtS8L6ts/5Bjp2GYgzsQlmPCRWE7Il94/6R18fg9ZZQ4rx280BrX60hKTFcM+rn6IuNAiT7wHMcsjonRLsbWW/ZaSmMwqJcfhRU2/8Slznw2AX8jHs3X/ZZtM8usm3Hd41U9m7DIRPgejo4wlgTmUrFJrgQIWdsuSCYm88a4BzFc3Wfa2No5stqkHZizsshx52UGOgvgJdxF6PUqC9af+qQSdldTcbOeQjgQbJOLfiZoPQzyO8DaszIzJkB8FB38DAgMBAAECggEBAIbZ7qzMjtCU3+SQdLZVFlQFGjk85sI/NvL5LkJL/T4Jx65eza9OQd2XyxH1rH1GpQK2CpbceozRnOPl/rNgaRSkILU8KNmgahYM9PXzN5huz3e2AKlOrjH3wNksZ7J2+c90bRUiNCrAXji0SpLTYzyXit8V8PLLQNuZoo4MG0iNCJy8riZwUn8ZQLJnCMv1VD0yUyGSr/6LAEJjJZTrrnpibw/99hqFO8Z6UvIs9JewfvjdzamT3UxF0gURSncieQwvsq3mYlq6ppcWqzBrEqJHZJOGzZrxtsOALmOFr7KCp6qRziareK/9vb9RLnZtBSrLZqhJF/MU1oFWpHixRoECgYEA3yKt0rT2v1rjaOlMQDF7pKKfnGmRHGps9214Smsj/wOwWdlwwixWZA2DUFLOUpPQRu3dPp3ZZQdcg21NejvEbtu4CcN0lrvnVlBIrExQmm9zqjDWijljtNvf+POqMkwyLumtNtdNxWLZxdiDClosShEX9kv4ttdlF5bEc2z3V8ECgYEA0rumR+zUnvT6OS6l6msUXgZ/f/XBgcW8BLdZV6pSJJVh3I9CVgc55MlTTGTd0yNfrDPVbwloDpjVVPSNI9YNL0h9i0vfMTHolWOR7RCcqBoquvt66NjtaV70PjBm1pxNVVDaUSgCva+oOFaRnoHjOSA+jyZkKRHjwnEWlcyRZ8MCgYBnZCtE6gM3cYbUEt35FLSk+ZGZqTTLBOlO0NOfL/vy6yOozl84KdEx9Sz2aBggHUuxwf/1RrD35ixQ3bG7xLvlXjvtkjqQqaqszPCPnaDvnlrq7kxKqgLwR72FHmqrebD7Gd3f/m2T25Tq3sMBZf0FqNwAjP1Gw5GdF4gZr9EAQQKBgQCQrWgxxTUMlOAd1hru3+kxzIBIl67sq5a0HjTmbPbMSwrO5EQE0B09J8NalX198bFDhqqn+utH6kG8e9FSoyiWJ8yZj9OB8OPffGa5PUhwWNaxXOo7ZoNIbnp9H7na6aBmTIY2ZaPMGwcA9t4u1rnrhGmu2gq176RQ4FdDLRk/BQKBgQDU+Oab3jL2MoDMtGk4ZGYQUcTMB/ILtG4O1bx8BhJZ/Rula3Rt7dYPrRng3uZ0sTVh7/QRSn02hLY72UoItge3POZMEbNQLb+gzhIuU4v4hLT3H6WK2MSaLftsb9mPyW9LX76xQS4ayf5xZqeKK2jOtIZCsiLmC/ALvIytcr2DHA==', '-----BEGIN CERTIFICATE-----\nMIIDrzCCApegAwIBAgIQICARFv38DKhJ31odYtzGpDANBgkqhkiG9w0BAQsFADCBgjELMAkGA1UE\nBhMCQ04xFjAUBgNVBAoMDUFudCBGaW5hbmNpYWwxIDAeBgNVBAsMF0NlcnRpZmljYXRpb24gQXV0\naG9yaXR5MTkwNwYDVQQDDDBBbnQgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IENs\nYXNzIDIgUjEwHhcNMjAxMTE2MDcwMTMwWhcNMjIxMTE2MDcwMTMwWjCBjzELMAkGA1UEBhMCQ04x\nKjAoBgNVBAoMIeWMl+S6rOmHj+WMlua0vuenkeaKgOaciemZkOWFrOWPuDEPMA0GA1UECwwGQWxp\ncGF5MUMwQQYDVQQDDDrmlK/ku5jlrp0o5Lit5Zu9Kee9kee7nOaKgOacr+aciemZkOWFrOWPuC0y\nMDg4OTMxOTU1NzA1MzIzMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAm9LT+VzzI6Zy\nr7ePg67m+6AB593Mpz9Pu3mdaYqhyN1MsW5p9l7Fjj/PSKJrCW7FzclCdDMVJrIMdopUMrscaHY8\nddncLA3+E0r5XK5+2lBmb35SNNlsKfVgnt122AymK5mkdar7rqOtQ1QrXM8NtlcY3UdZTUaPWbz5\n0A/t2tlMoUSM9EANgqQbrT7wPIG+5bq6VWW2piVcyx+Qh0CLHLd9E3QSJKyYzYfJpLFjiQlSa8/S\naEHuBQTREyuO0/Kz/2Pxt5r7kkU80Yd0l4E1/oYPd3EhMbRpFNh79LxKjVtgxWq1hf2sdarvT9Ce\nOftxnDn3yXTFXa9CEQqtByoANQIDAQABoxIwEDAOBgNVHQ8BAf8EBAMCA/gwDQYJKoZIhvcNAQEL\nBQADggEBAEiC3Dzm+oayzvSJoZZA3jrxdRJhJ6pQQ1vGcCe1mNfR7XKA0r4ht4J4weTryF9tmUVw\n6D+5UFdiA/2AfwOQ3rxmhc3TTN9xFDzm5koGfHFI9UV46PfBtugTUbgc+5HqsPPzcy6SvsQk3V17\n/3ua+c/wM4Db9S7JX0Ug2kfFYsGZ/IxRQYmTiHDcD4FYUKjAep0uPbVu0/Nc5gR2OKiGwwr8MvDQ\ndmozWdgJ42on5N7KkRNy0rRINQ9Z/QNMtQQ8GJB73rEbdty7q4psBsZ5Si2FuejNJSN4BuLybcM8\nIZRSYtUFCmzX9QoKfUMQO215f6bxMK9GZFu0TyWTxlXjvr0=\n-----END CERTIFICATE-----', '85ca16e8f3523e742f0f910f0d8444c4', '-----BEGIN CERTIFICATE-----\nMIIDrzCCApegAwIBAgIQICARFv38DKhJ31odYtzGpDANBgkqhkiG9w0BAQsFADCBgjELMAkGA1UE\nBhMCQ04xFjAUBgNVBAoMDUFudCBGaW5hbmNpYWwxIDAeBgNVBAsMF0NlcnRpZmljYXRpb24gQXV0\naG9yaXR5MTkwNwYDVQQDDDBBbnQgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IENs\nYXNzIDIgUjEwHhcNMjAxMTE2MDcwMTMwWhcNMjIxMTE2MDcwMTMwWjCBjzELMAkGA1UEBhMCQ04x\nKjAoBgNVBAoMIeWMl+S6rOmHj+WMlua0vuenkeaKgOaciemZkOWFrOWPuDEPMA0GA1UECwwGQWxp\ncGF5MUMwQQYDVQQDDDrmlK/ku5jlrp0o5Lit5Zu9Kee9kee7nOaKgOacr+aciemZkOWFrOWPuC0y\nMDg4OTMxOTU1NzA1MzIzMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAm9LT+VzzI6Zy\nr7ePg67m+6AB593Mpz9Pu3mdaYqhyN1MsW5p9l7Fjj/PSKJrCW7FzclCdDMVJrIMdopUMrscaHY8\nddncLA3+E0r5XK5+2lBmb35SNNlsKfVgnt122AymK5mkdar7rqOtQ1QrXM8NtlcY3UdZTUaPWbz5\n0A/t2tlMoUSM9EANgqQbrT7wPIG+5bq6VWW2piVcyx+Qh0CLHLd9E3QSJKyYzYfJpLFjiQlSa8/S\naEHuBQTREyuO0/Kz/2Pxt5r7kkU80Yd0l4E1/oYPd3EhMbRpFNh79LxKjVtgxWq1hf2sdarvT9Ce\nOftxnDn3yXTFXa9CEQqtByoANQIDAQABoxIwEDAOBgNVHQ8BAf8EBAMCA/gwDQYJKoZIhvcNAQEL\nBQADggEBAEiC3Dzm+oayzvSJoZZA3jrxdRJhJ6pQQ1vGcCe1mNfR7XKA0r4ht4J4weTryF9tmUVw\n6D+5UFdiA/2AfwOQ3rxmhc3TTN9xFDzm5koGfHFI9UV46PfBtugTUbgc+5HqsPPzcy6SvsQk3V17\n/3ua+c/wM4Db9S7JX0Ug2kfFYsGZ/IxRQYmTiHDcD4FYUKjAep0uPbVu0/Nc5gR2OKiGwwr8MvDQ\ndmozWdgJ42on5N7KkRNy0rRINQ9Z/QNMtQQ8GJB73rEbdty7q4psBsZ5Si2FuejNJSN4BuLybcM8\nIZRSYtUFCmzX9QoKfUMQO215f6bxMK9GZFu0TyWTxlXjvr0=\n-----END CERTIFICATE-----', '687b59193f3f462dd5336e5abf83c5d8_02941eef3187dddf3d3b83462e1dfcf6', '-----BEGIN CERTIFICATE-----\nMIIBszCCAVegAwIBAgIIaeL+wBcKxnswDAYIKoEcz1UBg3UFADAuMQswCQYDVQQG\nEwJDTjEOMAwGA1UECgwFTlJDQUMxDzANBgNVBAMMBlJPT1RDQTAeFw0xMjA3MTQw\nMzExNTlaFw00MjA3MDcwMzExNTlaMC4xCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVO\nUkNBQzEPMA0GA1UEAwwGUk9PVENBMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE\nMPCca6pmgcchsTf2UnBeL9rtp4nw+itk1Kzrmbnqo05lUwkwlWK+4OIrtFdAqnRT\nV7Q9v1htkv42TsIutzd126NdMFswHwYDVR0jBBgwFoAUTDKxl9kzG8SmBcHG5Yti\nW/CXdlgwDAYDVR0TBAUwAwEB/zALBgNVHQ8EBAMCAQYwHQYDVR0OBBYEFEwysZfZ\nMxvEpgXBxuWLYlvwl3ZYMAwGCCqBHM9VAYN1BQADSAAwRQIgG1bSLeOXp3oB8H7b\n53W+CKOPl2PknmWEq/lMhtn25HkCIQDaHDgWxWFtnCrBjH16/W3Ezn7/U/Vjo5xI\npDoiVhsLwg==\n-----END CERTIFICATE-----\n\n-----BEGIN CERTIFICATE-----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\nkT9qhqn+lw==\n-----END CERTIFICATE-----\n\n-----BEGIN CERTIFICATE-----\nMIICiDCCAgygAwIBAgIIQX76UsB/30owDAYIKoZIzj0EAwMFADB6MQswCQYDVQQG\nEwJDTjEWMBQGA1UECgwNQW50IEZpbmFuY2lhbDEgMB4GA1UECwwXQ2VydGlmaWNh\ndGlvbiBBdXRob3JpdHkxMTAvBgNVBAMMKEFudCBGaW5hbmNpYWwgQ2VydGlmaWNh\ndGlvbiBBdXRob3JpdHkgRTEwHhcNMTkwNDI4MTYyMDQ0WhcNNDkwNDIwMTYyMDQ0\nWjB6MQswCQYDVQQGEwJDTjEWMBQGA1UECgwNQW50IEZpbmFuY2lhbDEgMB4GA1UE\nCwwXQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxMTAvBgNVBAMMKEFudCBGaW5hbmNp\nYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgRTEwdjAQBgcqhkjOPQIBBgUrgQQA\nIgNiAASCCRa94QI0vR5Up9Yr9HEupz6hSoyjySYqo7v837KnmjveUIUNiuC9pWAU\nWP3jwLX3HkzeiNdeg22a0IZPoSUCpasufiLAnfXh6NInLiWBrjLJXDSGaY7vaokt\nrpZvAdmjXTBbMAsGA1UdDwQEAwIBBjAMBgNVHRMEBTADAQH/MB0GA1UdDgQWBBRZ\n4ZTgDpksHL2qcpkFkxD2zVd16TAfBgNVHSMEGDAWgBRZ4ZTgDpksHL2qcpkFkxD2\nzVd16TAMBggqhkjOPQQDAwUAA2gAMGUCMQD4IoqT2hTUn0jt7oXLdMJ8q4vLp6sg\nwHfPiOr9gxreb+e6Oidwd2LDnC4OUqCWiF8CMAzwKs4SnDJYcMLf2vpkbuVE4dTH\nRglz+HGcTLWsFs4KxLsq7MuU+vJTBUeDJeDjdA==\n-----END CERTIFICATE-----\n\n-----BEGIN CERTIFICATE-----\nMIIDxTCCAq2gAwIBAgIUEMdk6dVgOEIS2cCP0Q43P90Ps5YwDQYJKoZIhvcNAQEF\nBQAwajELMAkGA1UEBhMCQ04xEzARBgNVBAoMCmlUcnVzQ2hpbmExHDAaBgNVBAsM\nE0NoaW5hIFRydXN0IE5ldHdvcmsxKDAmBgNVBAMMH2lUcnVzQ2hpbmEgQ2xhc3Mg\nMiBSb290IENBIC0gRzMwHhcNMTMwNDE4MDkzNjU2WhcNMzMwNDE4MDkzNjU2WjBq\nMQswCQYDVQQGEwJDTjETMBEGA1UECgwKaVRydXNDaGluYTEcMBoGA1UECwwTQ2hp\nbmEgVHJ1c3QgTmV0d29yazEoMCYGA1UEAwwfaVRydXNDaGluYSBDbGFzcyAyIFJv\nb3QgQ0EgLSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOPPShpV\nnJbMqqCw6Bz1kehnoPst9pkr0V9idOwU2oyS47/HjJXk9Rd5a9xfwkPO88trUpz5\n4GmmwspDXjVFu9L0eFaRuH3KMha1Ak01citbF7cQLJlS7XI+tpkTGHEY5pt3EsQg\nwykfZl/A1jrnSkspMS997r2Gim54cwz+mTMgDRhZsKK/lbOeBPpWtcFizjXYCqhw\nWktvQfZBYi6o4sHCshnOswi4yV1p+LuFcQ2ciYdWvULh1eZhLxHbGXyznYHi0dGN\nz+I9H8aXxqAQfHVhbdHNzi77hCxFjOy+hHrGsyzjrd2swVQ2iUWP8BfEQqGLqM1g\nKgWKYfcTGdbPB1MCAwEAAaNjMGEwHQYDVR0OBBYEFG/oAMxTVe7y0+408CTAK8hA\nuTyRMB8GA1UdIwQYMBaAFG/oAMxTVe7y0+408CTAK8hAuTyRMA8GA1UdEwEB/wQF\nMAMBAf8wDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBBQUAA4IBAQBLnUTfW7hp\nemMbuUGCk7RBswzOT83bDM6824EkUnf+X0iKS95SUNGeeSWK2o/3ALJo5hi7GZr3\nU8eLaWAcYizfO99UXMRBPw5PRR+gXGEronGUugLpxsjuynoLQu8GQAeysSXKbN1I\nUugDo9u8igJORYA+5ms0s5sCUySqbQ2R5z/GoceyI9LdxIVa1RjVX8pYOj8JFwtn\nDJN3ftSFvNMYwRuILKuqUYSHc2GPYiHVflDh5nDymCMOQFcFG3WsEuB+EYQPFgIU\n1DHmdZcz7Llx8UOZXX2JupWCYzK1XhJb+r4hK5ncf/w8qGtYlmyJpxk3hr1TfUJX\nYf4Zr0fJsGuv\n-----END CERTIFICATE-----', 'SYS', '2021-08-21 21:15:02', 'SYS', '2021-09-08 14:31:30', '0', null, null, null);
INSERT INTO `pay_account` VALUES ('WXP', '1604055791', 'THRD', 'https://api.mch.weixin.qq.com', '微信', '77f7565be7d8992ab882d4dc31271c72', 'AES/GCM/NoPadding', 'SHA256WithRSA', '-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDEPyU3bE+upacg\nFqhLCCFVFxP4mWgr5TtTVFw9/JaGIptgwnf4bKurZM9EQrioRyHQrbrN3boSJChj\nogQ4ii1//cElpSn/KwLFPWzgtSdRP3KNrsBJ+//UJ98EB/ybA0ugV/7Biviv5zIF\n7SwGTi9tVlI4pgsRBdPJD6MFIrmPga4PuuvJI4ex2TBfELVvw5OQo0EQnxajopzE\n/cJMIiuuzEM3moaTquNJzkBp/XigHMm62o6m3zjtK7x5pnSw/8VO6i4KrHwBcXAb\nSg43+Bg3IQQdzbMflbO2jXQ1nHt7f0cGOIZQ93N4EP8CrLOEwFcS6Ku0vorWVIIT\npp2MOk3BAgMBAAECggEAbDH0Ls5EUCF8NrDHMDbXSbZjiFfrmufTAWotQO+VfXZu\n+7W7tvcS3nfB3fx7Giu9dPOTXhS0lXPh4Kxeb12fIEWiy0J4GPp5mIz5DhpSBvVY\nDs0drqyEq08gIXTVzBDRDSH2jnY0DacFaUcNUpyggUNqKVlCGKyBywQX+KjgbUE1\n7wPts8D6vlRngrg9IyJ6u+qEto7Yam9Ci5+GYUsgckUVw8DB4qIdolMgmBeFx+Su\ngm1A14dgoI8HWqGSo0Wx+L6HWGzg5NfQslQO09TkKPKaJQ65kPtu5juKhl+wLqaz\nJN3rOZSnXOSDehj529xJiB6tZ60dqcZ/5d4Pisa90QKBgQDyf5LFocoom9kMy3sb\nkH5HazNHL6CIBxGPDXgIoKLUbxfESS4gHrIa3lvJDwxKvcvtHek2Zgkp/RGRWEJb\ndomrmm1ojtzdk2NGoLo1kD3P+zLxv8ecPcTJWbu1+t4qDbm9guTwx3m+8LMrBGpM\nrocL2nAeT6wmo4T8ddpBGKcOgwKBgQDPLFQLHnzki9/1nUdTVkZ5eV+IvGGr0lS1\nq7fRL88FpYWQTFN6L63ggYwfQASNBv/Y9qRnx0D1LUN2FFHIFVx4xS0piHpGtCou\nDgMn3iS6sD+OpJXmI3IWwqhqz0nvCtB+AoLiQiimCSrBfyYeQDPB76mgl8/WnfcL\njReCnsc/awKBgQCI7q7jeIOeQLrktbYzj3kvPQJ8rRE6Hru0iseAH60yxfSmuygX\nrR2nfG5Z72xifCA+Kgi51g5Qrn2QFEWMPjhpNU+Ynitr10FU7YeYnXW6Dr/qsP+3\nY03O4SPVE+8F0jBTKim7KPi/cE3L+bdIy7ioYdWz2At+2hFLOgVfgts6nwKBgAtJ\n3A57C80cPgjRGBjXY6Gs1mLJ+Px2ynzXrX1tgHdLTJrPPeEzheLszCjLwTO6BOja\nj5zEA6sYW0us0cP4PgCqpcpUkG0X1hCKXOuoNBIkFmJ8X1qZ5daNpsWjI+Etkqy7\nEEyp1DMv3q+KcRZG40sW9wQ0IXQNSW/MsVJBupOfAoGAH7w5K0syqmSkeICJjnVV\ndX7r2O4ubpcGBnwCpEDA+qAgBXyGIjbuViiJvFJ5VbchJHWf7snCiwSa18iY9Y9C\n7vj/rOK79HJzdN2zqLSknIu61gkxiCFJw94MwushKpqE86IK7DgvO8LDMXQTN1pA\nRtYI48ZY49OjmmAXClLzUAg=\n-----END PRIVATE KEY-----', '-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxD8lN2xPrqWnIBaoSwgh\nVRcT+JloK+U7U1RcPfyWhiKbYMJ3+Gyrq2TPREK4qEch0K26zd26EiQoY6IEOIot\nf/3BJaUp/ysCxT1s4LUnUT9yja7ASfv/1CffBAf8mwNLoFf+wYr4r+cyBe0sBk4v\nbVZSOKYLEQXTyQ+jBSK5j4GuD7rrySOHsdkwXxC1b8OTkKNBEJ8Wo6KcxP3CTCIr\nrsxDN5qGk6rjSc5Aaf14oBzJutqOpt847Su8eaZ0sP/FTuouCqx8AXFwG0oON/gY\nNyEEHc2zH5Wzto10NZx7e39HBjiGUPdzeBD/AqyzhMBXEuirtL6K1lSCE6adjDpN\nwQIDAQAB\n-----END PUBLIC KEY-----', '3CC988718902E1499FF060DE7E56F2380B933047', '-----BEGIN CERTIFICATE-----\nMIID3DCCAsSgAwIBAgIUKn3YUdDrNwyEHWXptd6VyQ6/rScwDQYJKoZIhvcNAQEL\nBQAwXjELMAkGA1UEBhMCQ04xEzARBgNVBAoTClRlbnBheS5jb20xHTAbBgNVBAsT\nFFRlbnBheS5jb20gQ0EgQ2VudGVyMRswGQYDVQQDExJUZW5wYXkuY29tIFJvb3Qg\nQ0EwHhcNMjAxMTExMDcwODU0WhcNMjUxMTEwMDcwODU0WjBuMRgwFgYDVQQDDA9U\nZW5wYXkuY29tIHNpZ24xEzARBgNVBAoMClRlbnBheS5jb20xHTAbBgNVBAsMFFRl\nbnBheS5jb20gQ0EgQ2VudGVyMQswCQYDVQQGDAJDTjERMA8GA1UEBwwIU2hlblpo\nZW4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCdOrhA1eh7/GnfWmML\n1/ubOZQI9lVlCR2uAMu2yA2T6DY7fSc7TY7KCIFYQrv7puHIdePzBGNjIUe/ntTb\nMNN1Kbpno2hFr/2H40bOFGjmUyjPPUwuATh1yB+PQDsUt16fYS7nhETgPZwu4DOg\nwV9LzhonVsxxxd0Olx8LsmYDKUj1NZKm/4ufCnh1UaxSFtJpdYuGFnV1fUg3Brht\nWlbx9KlxnUrQ2HXs5D77x8c0rGtbMiKMySr/OMBypNKNFZgMQV7I43/ZjQDdNo/3\nntkml4z4+8ZBtYrdLyvUNI52TV1ggB5eijHd52NwsC5HhmiUj5WcHthy8rpGVdL5\n3tQbAgMBAAGjgYEwfzAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DBlBgNVHR8EXjBc\nMFqgWKBWhlRodHRwOi8vZXZjYS5pdHJ1cy5jb20uY24vcHVibGljL2l0cnVzY3Js\nP0NBPTFCRDQyMjBFNTBEQkMwNEIwNkFEMzk3NTQ5ODQ2QzAxQzNFOEVCRDIwDQYJ\nKoZIhvcNAQELBQADggEBAJbc/VUXit+/UZ9Tw1LOQtxSK4IT/Zf1dMvEYcGORmdu\n1pmLmwbgWhMQKrlVJGX/DXtbJFtGqTr6Dedfk3Scplt2SNGVBTXFEafCqhGLdiKq\nTHvTEGNf/iKEevCK3cyOm2dgSDbSAtJsNR81XsCV/lezigpa6ZyODW8k2B3uO12F\nu0OT5NH+g0Uo+Cejwuz5sePEBXVpIZbHdllPrX+hb5mwNflQjP4zeHp+T3D9C4qq\n2MoYNAhKreo68DV+P/TDfBZu7qy2oSr7E/hy7df71FVp/66w0b+Q6EJmODnjK6iW\nh/9FxORZwq0dHWN5bmUq1Jw/7EY+XJsc6xU4PvrIpjE=\n-----END CERTIFICATE-----', null, null, 'SYS', '2021-08-21 21:15:02', 'SYS', '2021-09-02 10:08:26', '0', null, null, null);

-- ----------------------------
-- Table structure for pay_app
-- ----------------------------
DROP TABLE IF EXISTS `pay_app`;
CREATE TABLE `pay_app` (
  `PAY_APP_ID` char(32) NOT NULL COMMENT '支付应用ID',
  `INSTITUTION_ID` char(4) NOT NULL COMMENT '机构ID',
  `PRODUCT_ID` char(4) NOT NULL COMMENT '产品ID',
  `PAY_APP_NAME` varchar(255) NOT NULL COMMENT '支付应用名称',
  `SECURITY_KEY` varchar(64) NOT NULL COMMENT '安全秘钥',
  `START_DATE` int(8) NOT NULL COMMENT '有效起始日',
  `END_DATE` int(8) NOT NULL COMMENT '有效结束日',
  `ACTIVATED_FLAG` char(1) NOT NULL,
  `CREATED_BY` varchar(32) NOT NULL DEFAULT '' COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL DEFAULT '' COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PAY_APP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='支付应用';

-- ----------------------------
-- Records of pay_app
-- ----------------------------
INSERT INTO `pay_app` VALUES ('wx2f44c7fe7b08458d', 'YXM', 'LDW', '小程序-狼大呜-H5', 'wx2f44c7fe7b08458d', '20210101', '20990101', 'Y', 'SYS', '2021-08-21 21:16:12', 'SYS', '2021-08-28 16:56:00', '0', null, null, null);
INSERT INTO `pay_app` VALUES ('wx75d5a207551d0b4d', 'YXM', 'LDW', '小程序-狼大呜-APP', 'wx75d5a207551d0b4d', '20210101', '20990101', 'Y', 'SYS', '2021-08-21 21:16:12', 'SYS', '2021-08-24 15:29:33', '0', null, null, null);
INSERT INTO `pay_app` VALUES ('wxd678efh567hg6787', 'YXM', 'LDW', '小程序-狼大呜', 'wqdv33g43fdfvwef2', '20210101', '20990101', 'Y', 'SYS', '2021-08-21 21:16:12', 'SYS', '2021-08-24 15:29:33', '0', null, null, null);

-- ----------------------------
-- Table structure for pay_feature
-- ----------------------------
DROP TABLE IF EXISTS `pay_feature`;
CREATE TABLE `pay_feature` (
  `PAY_CHAN_CODE` char(4) NOT NULL COMMENT '支付渠道码',
  `ACCESS_CODE` varchar(6) NOT NULL COMMENT '接入方法码（JS:小程序和网页; H5:h5页; APP:应用;）',
  `ACCESS_TYPE` char(3) NOT NULL COMMENT '接入类型（API:接口; SDK:工具库;）',
  `ACCESS_METHOD` varchar(255) DEFAULT NULL,
  `PRODUCT_CODE` varchar(255) DEFAULT NULL,
  `PAY_ACCESS` varchar(255) NOT NULL COMMENT '接入路径',
  `REFUND_ACCESS` varchar(255) NOT NULL,
  `CHECK_ACCESS` varchar(255) NOT NULL,
  `VERSION` char(4) NOT NULL COMMENT '接入版本号',
  `DESC_TEXT` varchar(255) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(32) NOT NULL DEFAULT 'SYS' COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL DEFAULT 'SYS' COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PAY_CHAN_CODE`,`ACCESS_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='支付特征';

-- ----------------------------
-- Records of pay_feature
-- ----------------------------
INSERT INTO `pay_feature` VALUES ('ALIP', 'APP', 'API', 'alipay.trade.app.pay', 'QUICK_MSECURITY_PAY', '/gateway.do', '', '', '1.0', 'APP支付', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('ALIP', 'CHKPAY', 'API', 'alipay.trade.query', null, '/gateway.do', '', '', '1.0', '查询订单', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('ALIP', 'CHKRFD', 'API', 'alipay.trade.fastpay.refund.query', null, '/gateway.do', '', '', '1.0', '退款查询', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('ALIP', 'CLOSE', 'API', 'alipay.trade.close', null, '/gateway.do', '', '', '1.0', '关闭订单', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('ALIP', 'H5', 'API', 'alipay.trade.wap.pay', 'QUICK_WAP_PAY', '/gateway.do', '', '', '1.0', '手机网站支付', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('ALIP', 'REFUND', 'API', 'alipay.trade.refund', null, '/gateway.do', '', '', '1.0', '退款', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('ALIP', 'WEB', 'API', 'alipay.trade.page.pay', 'FAST_INSTANT_TRADE_PAY', '/gateway.do', '', '', '1.0', '电脑网站支付', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'APP', 'API', 'POST', null, '/v3/pay/transactions/app', '', '', 'V3', '应用支付', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-08 10:39:40', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'CHKPAY', 'API', 'GET', null, '/v3/pay/transactions/out-trade-no/{out_trade_no}', '', '', 'V3', '查询订单', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-08 10:40:06', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'CHKRFD', 'API', 'GET', null, '/v3/refund/domestic/refunds/{out_refund_no}', '', '', 'V3', '退款查询', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-23 17:53:25', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'CLOSE', 'API', 'POST', null, '/v3/pay/transactions/out-trade-no/{out_trade_no}/close', '', '', 'V3', '关闭订单', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-08 10:40:29', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'H5', 'API', 'POST', null, '/v3/pay/transactions/h5', '', '', 'V3', 'H5页支付', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-08 10:39:48', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'JS', 'API', 'POST', null, '/v3/pay/transactions/jsapi', '', '', 'V3', '网页、小程序支付', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-08 10:39:51', '0', null, null, null);
INSERT INTO `pay_feature` VALUES ('WXP', 'REFUND', 'API', 'POST', null, '/v3/refund/domestic/refunds', '', '', 'V3', '退款', 'SYS', '2021-08-21 21:18:01', 'SYS', '2021-09-08 10:39:53', '0', null, null, null);

-- ----------------------------
-- Table structure for pay_goods_detail
-- ----------------------------
DROP TABLE IF EXISTS `pay_goods_detail`;
CREATE TABLE `pay_goods_detail` (
  `GOODS_ID` bigint(19) NOT NULL,
  `TRANSACTION_ID` bigint(19) NOT NULL,
  `GOODS_ORDER_NO` varchar(64) NOT NULL,
  `GOODS_NAME` varchar(512) NOT NULL,
  `QUANTITY` smallint(255) NOT NULL,
  `PRICE` decimal(19,2) NOT NULL,
  `DISC_AMOUNT` decimal(19,2) NOT NULL,
  `TXN_AMOUNT` decimal(19,2) NOT NULL,
  `ATTACH_TEXT` varchar(512) DEFAULT NULL,
  `PARTITION_KEY` smallint(4) NOT NULL COMMENT '分区键',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`GOODS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of pay_goods_detail
-- ----------------------------
INSERT INTO `pay_goods_detail` VALUES ('75774627147350019', '75774627146563586', '111111', '商品12', '1', '10.00', '2.50', '17.50', '---', '71', 'SYS', '2021-09-28 16:34:50', 'SYS', '2021-09-28 16:34:50', '1', null, null, null);
INSERT INTO `pay_goods_detail` VALUES ('75775132635168771', '75775132633989122', '111111', '商品12', '1', '10.00', '2.50', '17.50', '---', '71', 'SYS', '2021-09-28 18:43:52', 'SYS', '2021-09-28 18:43:52', '1', null, null, null);
INSERT INTO `pay_goods_detail` VALUES ('75797980930965765', '75797980930965508', '111111', '商品12', '1', '10.00', '2.50', '17.50', '---', '71', 'SYS', '2021-09-28 19:35:39', 'SYS', '2021-09-28 19:35:39', '1', null, null, null);
INSERT INTO `pay_goods_detail` VALUES ('75797981730112008', '75797981730111751', '111111', '商品12', '1', '10.00', '2.50', '17.50', '---', '71', 'SYS', '2021-09-28 19:35:51', 'SYS', '2021-09-28 19:35:51', '1', null, null, null);

-- ----------------------------
-- Table structure for status_code
-- ----------------------------
DROP TABLE IF EXISTS `status_code`;
CREATE TABLE `status_code` (
  `INSTITUTION_ID` char(4) NOT NULL COMMENT '机构ID',
  `ENTITY` char(4) NOT NULL COMMENT '实体码(ACCT:账户)',
  `CODE` char(4) NOT NULL COMMENT '状态码',
  `PRIORITY` smallint(4) NOT NULL COMMENT '优先值(0:最低)',
  `CODE_TYPE` char(4) NOT NULL COMMENT '状态类型(AUTO:自动/MANU:手动)',
  `POSTING_CODE` char(4) NOT NULL COMMENT '交易入账码(NORM:所有交易不能入账/ASUS:所有交易都可入账/DSUS:只有借记和非现金交易能入账)',
  `SEND_NOTICE_FLAG` char(1) NOT NULL COMMENT '发送给催收标记(Y/N)',
  `REGR_CODE` char(4) DEFAULT NULL COMMENT '回归码',
  `FAILED_CODE` char(4) NOT NULL,
  `NEXT_CODE` char(4) DEFAULT NULL COMMENT '下一个码值',
  `MESSAGE_CODE` char(4) DEFAULT NULL COMMENT '给用户的消息码',
  `DESC_TEXT` varchar(400) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(72) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(72) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`INSTITUTION_ID`,`ENTITY`,`CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of status_code
-- ----------------------------
INSERT INTO `status_code` VALUES ('YXM', 'PYMT', 'CLOS', '3', 'AUTO', 'NORM', 'Y', null, 'FAIL', null, null, '交易关闭', 'SYS', '2021-09-13 18:27:19', 'SYS', '2021-09-13 18:27:19', '0', null, null, null);
INSERT INTO `status_code` VALUES ('YXM', 'PYMT', 'DUE', '5', 'AUTO', 'NORM', 'N', null, 'FAIL', null, null, '交易超时', 'SYS', '2021-09-13 18:27:19', 'SYS', '2021-09-13 18:27:19', '0', null, null, null);
INSERT INTO `status_code` VALUES ('YXM', 'PYMT', 'FAIL', '4', 'AUTO', 'NORM', 'Y', null, 'FAIL', null, null, '交易失败', 'SYS', '2021-09-13 18:27:19', 'SYS', '2021-09-13 18:27:19', '0', null, null, null);
INSERT INTO `status_code` VALUES ('YXM', 'PYMT', 'PEND', '1', 'AUTO', 'NORM', 'N', null, 'FAIL', 'SUCC', null, '等待中', 'SYS', '2021-09-13 18:27:19', 'SYS', '2021-09-13 18:27:19', '0', null, null, null);
INSERT INTO `status_code` VALUES ('YXM', 'PYMT', 'SUCC', '2', 'AUTO', 'NORM', 'Y', null, 'FAIL', null, null, '交易成功', 'SYS', '2021-09-13 18:27:19', 'SYS', '2021-09-13 18:27:19', '0', null, null, null);

-- ----------------------------
-- Table structure for transaction_summary
-- ----------------------------
DROP TABLE IF EXISTS `transaction_summary`;
CREATE TABLE `transaction_summary` (
  `TRANSACTION_ID` bigint(19) NOT NULL,
  `CHECK_CODE` char(32) NOT NULL,
  `INSTITUTION_ID` char(4) NOT NULL,
  `PRODUCT_ID` char(4) NOT NULL,
  `EXTERNAL_ORDER_NO` char(64) NOT NULL,
  `GEN_ORDER_NO` varchar(64) NOT NULL,
  `ACCOUNT_ID` bigint(19) NOT NULL,
  `CHANNEL_ID` bigint(19) NOT NULL,
  `SUBJECT` varchar(128) NOT NULL,
  `STATUS_CODE` char(4) NOT NULL COMMENT '状态码',
  `ACCOUNT_NO` varchar(128) NOT NULL,
  `CURRENCY_CODE` char(3) NOT NULL,
  `PAY_METHOD` char(4) NOT NULL COMMENT '支付方式(AUTO:自动/DRST:主动/MANU:手动)',
  `TXN_TYPE` char(4) NOT NULL,
  `TXN_CODE` char(4) NOT NULL,
  `TXN_NO` int(11) NOT NULL,
  `STATISTICS_CODE` char(4) NOT NULL,
  `CREDIT_DEBIT_FLAG` char(1) NOT NULL,
  `CUSTOMER_GEN_FLAG` char(1) NOT NULL,
  `ORIGINAL_TXN_AMOUNT` decimal(17,2) NOT NULL,
  `TXN_AMOUNT` decimal(17,2) NOT NULL,
  `DISC_AMOUNT` decimal(17,2) NOT NULL,
  `GEN_FEE_AMOUNT` decimal(17,2) NOT NULL,
  `POST_CASH_AMOUNT` decimal(17,2) NOT NULL,
  `POST_CREDIT_AMOUNT` decimal(17,2) NOT NULL,
  `STATEMENTE_FLAG` char(1) NOT NULL,
  `TXN_DATE` int(8) NOT NULL,
  `TXN_TIME` int(6) NOT NULL,
  `PAY_DUE_TIME` bigint(14) NOT NULL,
  `REQUEST_ID` varchar(64) NOT NULL,
  `REQUEST_TIME` timestamp NOT NULL,
  `SHOP_NAME` varchar(255) DEFAULT NULL,
  `MOBILE_PHONE` varchar(13) DEFAULT NULL,
  `GOODS_SIGNER` varchar(60) DEFAULT NULL,
  `ADDRESS` varchar(500) DEFAULT NULL,
  `ATTACH_TEXT` varchar(512) DEFAULT NULL,
  `DESC_TEXT` varchar(400) DEFAULT NULL COMMENT '描述',
  `PARTITION_KEY` smallint(4) NOT NULL COMMENT '分区键',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`TRANSACTION_ID`),
  UNIQUE KEY `UK_EXT_IDS` (`CHECK_CODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of transaction_summary
-- ----------------------------
INSERT INTO `transaction_summary` VALUES ('75774627146563586', '3ffe82f6731f6e09255bc258d1131a75', 'YXM', 'LDW', '1111111111111111111111111', '', '75958421027815495', '75772285618946309', '测试订单1', 'PEND', 'oUpF8uMuAJO_M2pxb1Q9zNjWeS6o', 'CNY', 'DRST', 'PYMT', 'R001', '17', 'PYMT', 'C', 'Y', '110.00', '100.00', '10.00', '0.00', '100.00', '0.00', '1', '20210928', '163448', '20210928170450', '0884A7CB8A0610661890B68A4820B3C70328B4C303-0', '2021-09-28 16:34:48', '测试店铺', '13718656985', '测试员', '测试收货地址', 'AAAA-BBBB-1111-2222', 'https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx28163412174421409c9ab45bb8158a0000&package=701882712', '71', 'SYS', '2021-09-28 16:34:51', 'SYS', '2021-09-28 16:34:51', '1', null, null, null);
INSERT INTO `transaction_summary` VALUES ('75775132633989122', '99a0e05b2e0bdf7dcdcdd673e66e6b74', 'YXM', 'LDW', '1111111111111111111111112', '', '75958421027815495', '75772285618946309', '测试订单1', 'PEND', 'oUpF8uMuAJO_M2pxb1Q9zNjWeS6o', 'CNY', 'DRST', 'PYMT', 'R001', '18', 'PYMT', 'C', 'Y', '110.00', '100.00', '10.00', '0.00', '100.00', '0.00', '1', '20210928', '184322', '20210928191351', '08C1E3CB8A061096041891C5EEA30620D02E289F8806-0', '2021-09-28 18:43:22', '测试店铺', '13718656985', '测试员', '测试收货地址', 'AAAA-BBBB-1111-2222', 'https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx2818431363002927ab607e471496540000&package=532380239', '71', 'SYS', '2021-09-28 18:43:52', 'SYS', '2021-09-28 18:43:52', '1', null, null, null);
INSERT INTO `transaction_summary` VALUES ('75797980930965508', 'eb87068bf81ec98eacda438862ab647c', 'YXM', 'LDW', '1111111111111111111111113', '', '75958421027815495', '75772285618946309', '测试订单1', 'PEND', 'oUpF8uMuAJO_M2pxb1Q9zNjWeS6o', 'CNY', 'DRST', 'PYMT', 'R001', '19', 'PYMT', 'C', 'Y', '110.00', '100.00', '10.00', '0.00', '100.00', '0.00', '1', '20210928', '193538', '20210928200539', '088BFCCB8A06100C189DB78A4820C9930428DAC501-0', '2021-09-28 19:35:39', '测试店铺', '13718656985', '测试员', '测试收货地址', 'AAAA-BBBB-1111-2222', 'https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx28193539110439061fb25e1a67e8350000&package=704774955', '71', 'SYS', '2021-09-28 19:35:40', 'SYS', '2021-09-28 19:35:40', '1', null, null, null);
INSERT INTO `transaction_summary` VALUES ('75797981730111751', '182e268d5487e4a54183aebb47553688', 'YXM', 'LDW', '1111111111111111111111114', '', '75958421027815495', '75772285618946309', '测试订单1', 'PEND', 'oUpF8uMuAJO_M2pxb1Q9zNjWeS6o', 'CNY', 'DRST', 'PYMT', 'R001', '20', 'PYMT', 'C', 'Y', '110.00', '100.00', '10.00', '0.00', '100.00', '0.00', '1', '20210928', '193551', '20210928200551', '0897FCCB8A0610E80118ADC2DE48208BC207289039-0', '2021-09-28 19:35:51', '测试店铺', '13718656985', '测试员', '测试收货地址', 'AAAA-BBBB-1111-2222', 'https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx28193551336948ac3a89a59ae358bf0000&package=2512202361', '71', 'SYS', '2021-09-28 19:35:51', 'SYS', '2021-09-28 19:35:51', '1', null, null, null);
