package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.AccessCode;
import cn.quant.spring.data.jpa.entity.DescriptionEntity;
import cn.quant.spring.util.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Entity
@Table(name = "mch_channel")
public class MchChannelEntity extends DescriptionEntity implements Serializable {
    private static final long serialVersionUID = 2948677889658286512L;
    private final static String CLASS_NAME = MchChannelEntity.class.getSimpleName();

    @Id
    @Column(name = "ID", nullable = false, updatable = false)
    private Long id;

    @Column(name = "PAY_APP_ID", nullable = false, length = 32)
    private String payAppId;

    @Column(name = "PAY_CHAN_CODE", nullable = false, length = 4)
    private String payChanCode;

    @Column(name = "PAY_ACCT_ID", nullable = false, length = 64)
    private String payAcctId;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "ACCESS_CODE", nullable = false, length = 3)
    private AccessCode accessCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPayAppId() {
        return payAppId;
    }

    public void setPayAppId(String payAppId) {
        this.payAppId = payAppId;
    }

    public String getPayChanCode() {
        return payChanCode;
    }

    public void setPayChanCode(String payChanCode) {
        this.payChanCode = payChanCode;
    }

    public String getPayAcctId() {
        return payAcctId;
    }

    public void setPayAcctId(String payAcctId) {
        this.payAcctId = payAcctId;
    }

    public AccessCode getAccessCode() {
        return accessCode;
    }

    public void setAccessCode(AccessCode accessCode) {
        this.accessCode = accessCode;
    }

    @Override
    public String persistenceKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MchChannelEntity that = (MchChannelEntity) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("MchChannelEntity{");
        sb.append("id=").append(id);
        sb.append(", payAppId='").append(payAppId).append('\'');
        sb.append(", payChanCode='").append(payChanCode).append('\'');
        sb.append(", payAcctId='").append(payAcctId).append('\'');
        sb.append(", accessCode=").append(accessCode);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
