package cn.quant.baa.pay.config;

import cn.quant.baa.pay.support.AuditorAwareHandler;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * <p><b>Enable Mybatis Annotation:</b><br/>
 * <code>@org.mybatis.spring.annotation.MapperScan("cn.quant.baa.pay.mybatis.mapper")</code></p>
 * <p><b>Enable JPA Annotation:</b><br/>
 * <code>@EntityScan("cn.quant.baa.pay.jpa.entity")</code><br/>
 * <code>@org.springframework.data.jpa.repository.config.EnableJpaRepositories("cn.quant.baa.pay.jpa.repository")</code></p>
 * <p><b>Enable Auditor Aware Annotation:</b><br/>
 * <code>@org.springframework.data.jpa.repository.config.EnableJpaAuditing(auditorAwareRef = "auditorAwareHandler")<br/>
 * see {@link AuditorAwareHandler}</code>
 * </p>
 * @see cn.quant.spring.convert.LocalDateNumberConverter
 * @see cn.quant.spring.convert.LocalDateTimeNumberConverter
 * @see cn.quant.spring.convert.LocalTimeNumberConverter
 */
@Configuration
@EnableTransactionManagement
@EntityScan("cn.quant.baa.pay.jpa.entity")
@EnableJpaRepositories("cn.quant.baa.pay.jpa.repository")
@EnableJpaAuditing(auditorAwareRef = "auditorAwareHandler")
public class DatabaseConfiguration {
    //    TODO:Hibernate Jackson Support
    @Bean
    public Hibernate5Module hibernate5Module() {
        return new Hibernate5Module();
    }
}